/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"}, sequential=true)
public class ConnectStressTest
extends ChannelTestBase {
    static final int NUM = 20;
    private final CyclicBarrier barrier = new CyclicBarrier(21);
    private final MyThread[] threads = new MyThread[20];
    static final String groupname = "ConnectStressTest";

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    public void testConcurrentJoinsAndLeaves() throws Exception {
        View view;
        JChannel first = null;
        this.channel_conf = "udp.xml";
        for (int i = 0; i < this.threads.length; ++i) {
            JChannel ch = null;
            if (i == 0) {
                first = ch = this.createChannel(true, 20);
            } else {
                ch = this.createChannel(first);
            }
            ch.setName("C" + i);
            ConnectStressTest.changeProperties(ch);
            this.threads[i] = new MyThread(ch, i + 1, this.barrier);
            this.threads[i].start();
        }
        this.barrier.await();
        System.out.println("*** Starting the connect phase ***");
        long target_time = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < target_time) {
            View view2 = this.threads[0].getChannel().getView();
            if (view2 != null) {
                int size = view2.size();
                System.out.println("channel[0].view has " + size + " members (expected: " + 20 + ")");
                if (size >= 20) break;
            }
            Util.sleep(1000L);
        }
        for (MyThread thread : this.threads) {
            view = thread.getChannel().getView();
            System.out.println(thread.getName() + ": size=" + view.size() + ", view-id: " + view.getViewId());
        }
        for (MyThread thread : this.threads) {
            view = thread.getChannel().getView();
            int size = view.size();
            assert (size == 20) : "view doesn't have size of 20 (has " + size + "): " + view;
        }
        System.out.println("*** Starting the disconnect phase ***");
        for (int i = 0; i < this.threads.length; ++i) {
            MyThread thread = this.threads[i];
            System.out.print("disconnecting " + thread.getName());
            thread.disconnect();
            System.out.println(" OK");
        }
    }

    private static void changeProperties(JChannel ch) {
        NAKACK nakack;
        MERGE2 merge;
        ProtocolStack stack = ch.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol("GMS");
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(300L);
            gms.setPrintLocalAddr(false);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(2000L);
            merge.setMaxInterval(5000L);
        }
        if ((nakack = (NAKACK)stack.findProtocol((Class<?>)NAKACK.class)) != null) {
            nakack.setLogDiscardMsgs(false);
        }
    }

    public static class MyThread
    extends Thread {
        private final CyclicBarrier barrier;
        private final JChannel ch;

        public MyThread(JChannel channel, int i, CyclicBarrier barrier) {
            super("thread #" + i);
            this.ch = channel;
            this.barrier = barrier;
        }

        public void disconnect() {
            this.ch.disconnect();
        }

        public void close() {
            Util.close((Channel)this.ch);
        }

        public JChannel getChannel() {
            return this.ch;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
                this.ch.connect(ConnectStressTest.groupname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

