/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"})
public class MuxRpcDispatcherTest
extends ChannelTestBase {
    private JChannel[] channels = new JChannel[2];
    private RpcDispatcher[] dispatchers = new RpcDispatcher[2];
    private RpcDispatcher[][] muxDispatchers = new RpcDispatcher[2][2];

    @BeforeClass
    void setUp() throws Exception {
        this.channels[0] = this.createChannel(true);
        this.channels[1] = this.createChannel(this.channels[0]);
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.dispatchers[i] = new RpcDispatcher((Channel)this.channels[i], null, null, new Server("dispatcher[" + i + "]"));
            this.channels[i].setUpHandler(new MuxUpHandler(this.dispatchers[i].getProtocolAdapter()));
            for (int j = 0; j < this.muxDispatchers[i].length; ++j) {
                this.muxDispatchers[i][j] = new MuxRpcDispatcher((short)j, this.channels[i], null, null, (Object)new Server("muxDispatcher[" + i + "][" + j + "]"));
            }
            this.channels[i].connect("MuxRpcDispatcherTest");
            Util.sleep(1000L);
        }
    }

    @AfterClass
    void tearDown() throws Exception {
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.channels[i].disconnect();
            this.channels[i].close();
            this.dispatchers[i].stop();
            for (int j = 0; j < this.muxDispatchers[i].length; ++j) {
                this.muxDispatchers[i][j].stop();
            }
        }
    }

    public void testMulticastRPCs() throws Exception {
        MethodCall method = new MethodCall("getName", new Object[0], new Class[0]);
        RspList responses = this.dispatchers[0].callRemoteMethods(null, method, RequestOptions.SYNC);
        Assert.assertEquals((int)responses.size(), (int)2);
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.verifyResponse(responses, this.channels[i], "dispatcher[" + i + "]");
        }
        for (int j = 0; j < this.muxDispatchers[0].length; ++j) {
            responses = this.muxDispatchers[0][j].callRemoteMethods(null, method, RequestOptions.SYNC);
            Assert.assertEquals((int)responses.size(), (int)2);
            for (int i = 0; i < this.dispatchers.length; ++i) {
                this.verifyResponse(responses, this.channels[i], "muxDispatcher[" + i + "][" + j + "]");
            }
        }
        final Address address = this.channels[0].getAddress();
        RspFilter filter = new RspFilter(){

            @Override
            public boolean isAcceptable(Object response, Address sender) {
                return !sender.equals(address);
            }

            @Override
            public boolean needMoreResponses() {
                return true;
            }
        };
        responses = this.muxDispatchers[0][0].callRemoteMethods(null, method, RequestOptions.SYNC.setRspFilter(filter));
        Assert.assertEquals((int)responses.size(), (int)2);
        this.verifyResponse(responses, this.channels[0], null);
        this.verifyResponse(responses, this.channels[1], "muxDispatcher[1][0]");
        this.muxDispatchers[1][0].stop();
        responses = this.muxDispatchers[0][0].callRemoteMethods(null, method, RequestOptions.SYNC.setRspFilter(null));
        Assert.assertEquals((int)responses.size(), (int)2);
        this.verifyResponse(responses, this.channels[0], "muxDispatcher[0][0]");
        this.verifyResponse(responses, this.channels[1], null);
        responses = this.muxDispatchers[0][0].callRemoteMethods(null, method, RequestOptions.SYNC.setRspFilter(filter));
        Assert.assertEquals((int)responses.size(), (int)2);
        this.verifyResponse(responses, this.channels[0], null);
        this.verifyResponse(responses, this.channels[1], null);
        this.muxDispatchers[1][0].start();
        responses = this.muxDispatchers[0][0].callRemoteMethods(null, method, RequestOptions.SYNC.setRspFilter(null));
        Assert.assertEquals((int)responses.size(), (int)2);
        this.verifyResponse(responses, this.channels[0], "muxDispatcher[0][0]");
        this.verifyResponse(responses, this.channels[1], "muxDispatcher[1][0]");
    }

    public void testUnicastRPCs() throws Throwable {
        MethodCall method = new MethodCall("getName", new Object[0], new Class[0]);
        Address address = this.channels[1].getAddress();
        Object response = this.dispatchers[0].callRemoteMethod(address, method, RequestOptions.SYNC);
        Assert.assertEquals((Object)response, (Object)"dispatcher[1]");
        for (int j = 0; j < this.muxDispatchers[0].length; ++j) {
            response = this.muxDispatchers[0][j].callRemoteMethod(address, method, RequestOptions.SYNC);
            Assert.assertEquals((Object)response, (Object)("muxDispatcher[1][" + j + "]"));
        }
    }

    private void verifyResponse(Map<Address, Rsp> responses, Channel channel, Object expected) {
        Rsp response = responses.get(channel.getAddress());
        String address = channel.getAddress().toString();
        Assert.assertNotNull((Object)response, (String)address);
        Assert.assertFalse((boolean)response.wasSuspected(), (String)address);
        if (expected != null) {
            Assert.assertTrue((boolean)response.wasReceived(), (String)address);
            Assert.assertEquals(response.getValue(), (Object)expected, (String)address);
        } else {
            Assert.assertFalse((boolean)response.wasReceived(), (String)address);
        }
    }

    public static class Server {
        private final String name;

        public Server(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

