/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.AbstractViettelChannel;
import com.viettel.common.Authenticator;
import com.viettel.common.ViettelChannelHandler;
import com.viettel.common.ViettelMsg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class ObjectServerChannel
extends AbstractViettelChannel {
    private Hashtable<Long, IoSession> sessions;
    private final Map<String, SessionInfor> ssInfors;
    private SimpleDateFormat d = new SimpleDateFormat("HH:mm:ss dd-MM-yyyy");
    private final Map<String, Long> sessionQuota;
    private Authenticator authenticator;
    private NioSocketAcceptor acceptor;
    private int port;
    private final Object lockReceived = new Object();
    private final Object lockReqSend = new Object();
    private final Object lockReqSent = new Object();

    public ObjectServerChannel() {
        this.sessions = new Hashtable();
        this.ssInfors = Collections.synchronizedMap(new HashMap());
        this.sessionQuota = Collections.synchronizedMap(new HashMap());
    }

    public ObjectServerChannel(int port) {
        this();
        this.port = port;
    }

    private SessionInfor getSessionInfor(String userId) {
        SessionInfor infor = this.ssInfors.get(userId);
        if (infor == null) {
            infor = new SessionInfor(userId);
            this.ssInfors.put(userId, infor);
        }
        return infor;
    }

    public ViettelMsg send(ViettelMsg message) throws IOException {
        throw new IOException("send synchronous method is not supported on server channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsyn(ViettelMsg message) throws IOException {
        Object object = this.lockReqSend;
        synchronized (object) {
            this.reqSend = ObjectServerChannel.increase(this.reqSend, 1L);
        }
        SessionInfor infor = this.getSessionInfor(message.getClientId());
        infor.requestSend = ObjectServerChannel.increase(infor.requestSend, 1L);
        IoSession session = this.sessions.get(message.getProperty("session-" + this.getChannelId()));
        if (session == null || !session.isConnected()) {
            throw new IOException("no client session[" + message.getClientId() + "], may be it" + " has been closed or not connected");
        }
        WriteFuture future = session.write((Object)message);
        if (future.getException() != null) {
            infor.sendFailure = ObjectServerChannel.increase(infor.sendFailure, 1L);
            throw new IOException("channel is closing or disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.acceptor != null) {
                throw new IOException("The Channel has connected already");
            }
            this.acceptor = new NioSocketAcceptor();
            DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
            MdcInjectionFilter mdcInjectionFilter = new MdcInjectionFilter();
            chain.addLast("mdc", (IoFilter)mdcInjectionFilter);
            ProtocolCodecFilter protocolFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory());
            chain.addLast("codec", (IoFilter)protocolFilter);
            if (this.logger != null) {
                this.logger.info((Object)("the server channel connected, port " + this.port));
            }
            this.acceptor.setHandler((IoHandler)new IOSessionHandler());
            this.acceptor.bind(new SocketAddress[]{new InetSocketAddress(this.port)});
            this.connected = true;
            this.logged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.acceptor != null) {
                this.acceptor.unbind();
                this.acceptor.dispose();
                this.acceptor = null;
            }
            if (this.sessions != null) {
                this.sessions.clear();
            }
            this.info("the server channel disconnected");
            this.connected = false;
            this.logged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        Object object = this.lock;
        synchronized (object) {
            this.port = port;
        }
    }

    public void setChannelType(int channelType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticator(Authenticator authenticator) {
        Object object = this.lock;
        synchronized (object) {
            this.authenticator = authenticator;
        }
    }

    public String getInfor() {
        StringBuffer buffer = new StringBuffer("Object Server Channel");
        buffer.append("\r\nRequest Send:" + this.reqSend);
        buffer.append("\r\nSent:" + this.sent);
        buffer.append("\r\nReceived:" + this.received);
        for (SessionInfor infor : this.ssInfors.values()) {
            buffer.append("\r\n");
            buffer.append(infor.getInfor());
        }
        return buffer.toString();
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        ArrayList<MBeanAttributeInfo> v = new ArrayList<MBeanAttributeInfo>();
        v.add(new MBeanAttributeInfo("port", "java.lang.Integer", "The listening port", true, false, false));
        return v.toArray(new MBeanAttributeInfo[v.size()]);
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attribute_name.equals("port")) {
            return this.port;
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.dClassName);
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        MBeanParameterInfo[] getParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ip/user/id", "java.lang.String", "client ip or usrname or session id")};
        v.add(new MBeanOperationInfo("getSessions", "get session by client ip or user or session id", getParams, "java.lang.String", 1));
        v.add(new MBeanOperationInfo("getAllSessions", "get all sessions", params, "java.lang.String", 1));
        v.add(new MBeanOperationInfo("getUserInfos", "get session infomations by user", params, "java.lang.String", 1));
        MBeanParameterInfo[] quotaParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ip/user", "java.lang.String", "client ip or username"), new MBeanParameterInfo("max", "long", "max sessions")};
        v.add(new MBeanOperationInfo("setQuota", "set max of session for client ip", quotaParams, "boolean", 1));
        MBeanParameterInfo[] rquotaParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ip/user", "java.lang.String", "client ip or username")};
        v.add(new MBeanOperationInfo("removeQuota", "remove limited session for client ip or user", rquotaParams, "boolean", 1));
        v.add(new MBeanOperationInfo("removeAllQuota", "remove limited session for all client", params, "void", 1));
        v.add(new MBeanOperationInfo("getQuotaList", "get all client that have quota", params, "java.lang.String", 1));
        MBeanParameterInfo[] killParams = new MBeanParameterInfo[]{new MBeanParameterInfo("ip/user/id", "java.lang.String", "client ip or username or session id")};
        v.add(new MBeanOperationInfo("killSessions", "kill session by client ip or or user or session id", killParams, "boolean", 1));
        v.add(new MBeanOperationInfo("killAllSessions", "kill all sessions", params, "boolean", 1));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        try {
            if (operationName.equals("getAllSessions")) {
                return this.getAllSessions();
            }
            if (operationName.equals("getSessions")) {
                String param = "";
                if (params.length >= 1) {
                    param = params[0].toString();
                }
                return this.getSessions(param);
            }
            if (operationName.equals("getUserInfos")) {
                return this.getUserInfos();
            }
            if (operationName.equals("killSessions")) {
                if (params.length >= 1) {
                    String ip = params[0].toString();
                    return this.killSessions(ip);
                }
                return false;
            }
            if (operationName.equals("killAllSessions")) {
                return this.killAllSessions();
            }
            if (operationName.equals("setQuota")) {
                if (params.length >= 2) {
                    String clinetIp = params[0].toString();
                    long max = 0L;
                    try {
                        max = Long.parseLong(params[1].toString());
                    }
                    catch (NumberFormatException ex) {
                        return "invalid number";
                    }
                    return this.setQuota(clinetIp, max);
                }
                return false;
            }
            if (operationName.equals("removeQuota")) {
                if (params.length >= 1) {
                    String clientIp = params[0].toString();
                    return this.removeQuota(clientIp);
                }
                return false;
            }
            if (operationName.equals("removeAllQuota")) {
                this.removeAllQuota();
                return null;
            }
            if (operationName.equals("getQuotaList")) {
                return this.getQuotaList();
            }
            return super.invoke(operationName, params, signature);
        }
        catch (Exception ex) {
            this.logger.warn((Object)ex);
            return ex.toString();
        }
    }

    private boolean killSessions(String param) {
        if (this.sessions.size() == 0) {
            return false;
        }
        boolean killSeccessful = false;
        ArrayList<IoSession> asessions = new ArrayList<IoSession>(this.sessions.values());
        boolean isIp = param.split("\\.").length == 4;
        for (int i = 0; i < asessions.size(); ++i) {
            boolean isKill;
            boolean isUser;
            IoSession session;
            block12: {
                session = asessions.get(i);
                if (isIp) {
                    String clientIp = "";
                    InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
                    if (address.isUnresolved()) {
                        clientIp = address.getHostName();
                    } else {
                        clientIp = address.getAddress().toString();
                        if (clientIp.charAt(0) == '/') {
                            clientIp = clientIp.substring(1);
                        }
                    }
                    if (!clientIp.equalsIgnoreCase(param)) continue;
                    this.sessions.remove(session.getId());
                    session.close(true);
                    killSeccessful = true;
                    continue;
                }
                isUser = false;
                long sessionId = session.getId();
                long inId = 0L;
                isKill = false;
                try {
                    inId = Long.parseLong(param);
                    if (sessionId == inId) {
                        isKill = true;
                    }
                }
                catch (Exception ex) {
                    if (param.contains("x") || param.contains("X")) {
                        int pos = 0;
                        for (int j = 0; j < param.length(); ++j) {
                            if (param.charAt(j) == '0' || param.charAt(j) == 'x' || param.charAt(j) == 'X') continue;
                            pos = j;
                            break;
                        }
                        String hexString = param.substring(pos);
                        String idHex = Long.toHexString(sessionId);
                        if (idHex.equalsIgnoreCase(hexString)) {
                            isKill = true;
                        }
                    }
                    isUser = true;
                    String user = MdcInjectionFilter.getProperty((IoSession)session, (String)"user");
                    if (!user.equalsIgnoreCase(param)) break block12;
                    isKill = true;
                }
            }
            if (!isKill) continue;
            this.sessions.remove(session.getId());
            session.close(true);
            killSeccessful = true;
            if (!isUser) break;
        }
        asessions.clear();
        return killSeccessful;
    }

    private boolean killAllSessions() {
        if (this.sessions.size() == 0) {
            return false;
        }
        ArrayList<IoSession> asessions = new ArrayList<IoSession>(this.sessions.values());
        for (int i = 0; i < asessions.size(); ++i) {
            IoSession session = asessions.get(i);
            this.sessions.remove(session.getId());
            session.close(true);
        }
        asessions.clear();
        return true;
    }

    private String getAllSessions() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Number of sessions: " + this.sessions.size() + "\n");
        for (IoSession session : this.sessions.values()) {
            SessionInfor ssInfo = (SessionInfor)session.getAttribute((Object)"user");
            buffer.append(session + ", User Info: " + ssInfo.getInfor() + "\n");
        }
        return buffer.toString();
    }

    private String getSessions(String param) {
        StringBuffer buffer = new StringBuffer();
        Iterator<IoSession> iter = this.sessions.values().iterator();
        String[] tmp = param.split("\\.");
        long nsessions = 0L;
        if (tmp.length == 4) {
            while (iter.hasNext()) {
                IoSession session = iter.next();
                String clientIp = "";
                InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
                if (address.isUnresolved()) {
                    clientIp = address.getHostName();
                } else {
                    clientIp = address.getAddress().toString();
                    if (clientIp.charAt(0) == '/') {
                        clientIp = clientIp.substring(1);
                    }
                }
                if (!clientIp.equalsIgnoreCase(param)) continue;
                SessionInfor ssInfo = (SessionInfor)session.getAttribute((Object)"user");
                buffer.append(session + ", Info: " + ssInfo.getInfor() + "\n");
                ++nsessions;
            }
        } else {
            boolean isUser = false;
            while (iter.hasNext()) {
                boolean isGet;
                IoSession session;
                block13: {
                    session = iter.next();
                    long sessionId = session.getId();
                    long inId = 0L;
                    isGet = false;
                    try {
                        inId = Long.parseLong(param);
                        if (sessionId == inId) {
                            isGet = true;
                        }
                    }
                    catch (Exception ex) {
                        if (param.contains("x") || param.contains("X")) {
                            int pos = 0;
                            for (int i = 0; i < param.length(); ++i) {
                                if (param.charAt(i) == '0' || param.charAt(i) == 'x' || param.charAt(i) == 'X') continue;
                                pos = i;
                                break;
                            }
                            String hexString = param.substring(pos);
                            String idHex = Long.toHexString(sessionId);
                            if (idHex.equalsIgnoreCase(hexString)) {
                                isGet = true;
                            }
                        }
                        isUser = true;
                        String user = MdcInjectionFilter.getProperty((IoSession)session, (String)"user");
                        if (!user.equalsIgnoreCase(param)) break block13;
                        isGet = true;
                    }
                }
                if (!isGet) continue;
                SessionInfor ssInfo = (SessionInfor)session.getAttribute((Object)"user");
                buffer.append(session + ", Info: " + ssInfo.getInfor() + "\n");
                ++nsessions;
                if (isUser) continue;
                break;
            }
        }
        buffer.append("Number of sessions: " + nsessions);
        return buffer.toString();
    }

    private String getUserInfos() {
        StringBuffer buffer = new StringBuffer();
        for (String key : this.ssInfors.keySet()) {
            SessionInfor ssInfo = this.getSessionInfor(key);
            buffer.append(ssInfo.getInfor() + "\n");
        }
        return buffer.toString();
    }

    private boolean setQuota(String param, long max) {
        String[] isIp = param.split("\\.");
        long nCurrentSessions = 0L;
        String currentSessions = this.getSessions(param);
        if (!currentSessions.trim().equalsIgnoreCase("")) {
            nCurrentSessions = currentSessions.split("\n").length - 1;
        }
        if (nCurrentSessions > 0L && nCurrentSessions > max) {
            ArrayList<IoSession> asessions = new ArrayList<IoSession>(this.sessions.values());
            long nremove = 0L;
            for (int i = 0; i < asessions.size(); ++i) {
                IoSession session = asessions.get(i);
                boolean isRemove = false;
                if (isIp.length == 4) {
                    String ip = "";
                    InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
                    if (address.isUnresolved()) {
                        ip = address.getHostName();
                    } else {
                        ip = address.getAddress().toString();
                        if (ip.charAt(0) == '/') {
                            ip = ip.substring(1);
                        }
                    }
                    if (ip.equalsIgnoreCase(param)) {
                        isRemove = true;
                    }
                } else {
                    String user = MdcInjectionFilter.getProperty((IoSession)session, (String)"user");
                    if (user.equalsIgnoreCase(param)) {
                        isRemove = true;
                    }
                }
                if (!isRemove) continue;
                this.sessions.remove(session.getId());
                session.close(true);
                if (++nremove >= nCurrentSessions - max) break;
            }
            asessions.clear();
        }
        this.sessionQuota.put(param, max);
        return true;
    }

    private boolean removeQuota(String param) {
        if (!this.sessionQuota.keySet().contains(param)) {
            return false;
        }
        this.sessionQuota.remove(param);
        return true;
    }

    private void removeAllQuota() {
        this.sessionQuota.clear();
    }

    private boolean isQuota(String param) {
        if (null == this.sessionQuota.get(param)) {
            return true;
        }
        if (this.sessionQuota.get(param) <= 0L) {
            return false;
        }
        String sess = this.getSessions(param);
        long nsession = 0L;
        return sess.trim().equalsIgnoreCase("") || (nsession = (long)(sess.split("\n").length - 1)) < this.sessionQuota.get(param);
    }

    private String getQuotaList() {
        StringBuffer buffer = new StringBuffer();
        for (String key : this.sessionQuota.keySet()) {
            long max = this.sessionQuota.get(key);
            buffer.append(key + ": " + max + "\n");
        }
        return buffer.toString();
    }

    private static class SessionInfor {
        String userId;
        String connectedTime;
        long connect;
        long disconnect;
        long requestSend;
        long sent;
        long received;
        long sendFailure;

        public SessionInfor(String userId) {
            this.userId = userId;
        }

        public String getInfor() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[UserId:" + this.userId);
            buffer.append(",Last Connected:" + this.connectedTime);
            buffer.append(",Connect:" + this.connect);
            buffer.append(",Disconnect:" + this.disconnect);
            buffer.append(",Request Send:" + this.requestSend);
            buffer.append(",Sent:" + this.sent);
            buffer.append(",Send Failure:" + this.sendFailure + "]");
            return buffer.toString();
        }
    }

    class IOSessionHandler
    extends IoHandlerAdapter {
        private static final int IDLE_TIME = 900;

        IOSessionHandler() {
        }

        public void sessionOpened(IoSession session) {
            ObjectServerChannel.this.debug("session[" + session.getId() + "] opened");
            session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 900);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoSession session, Object message) {
            ObjectServerChannel.this.debug("session[" + session.getId() + "] received:" + message);
            if (message instanceof ViettelMsg) {
                Object object = ObjectServerChannel.this.lockReceived;
                synchronized (object) {
                    ObjectServerChannel.this.received = AbstractViettelChannel.increase(ObjectServerChannel.this.received, 1L);
                }
                ViettelMsg request = (ViettelMsg)message;
                String timeOut = new Long(System.currentTimeMillis()) + ":" + ObjectServerChannel.this.getReceiverTimeout();
                request.setProperty("TimeOutInfo", timeOut);
                request.setProperty("session-" + ObjectServerChannel.this.getChannelId(), session.getId());
                request.setProperty("session", session.getId());
                String command = request.getCommand();
                if ("ECHO".equals(command)) {
                    ViettelMsg response = request.getResponse();
                    Object object2 = ObjectServerChannel.this.lockReqSend;
                    synchronized (object2) {
                        ObjectServerChannel.this.reqSend = AbstractViettelChannel.increase(ObjectServerChannel.this.reqSend, 1L);
                    }
                    session.write((Object)response);
                    return;
                }
                if ("AUTHEN".equals(command)) {
                    Object object3;
                    if (ObjectServerChannel.this.authenticator == null) {
                        ObjectServerChannel.this.debug("authenticator is null, forward login request to handler");
                        Set response = ObjectServerChannel.this.handlers;
                        synchronized (response) {
                            for (ViettelChannelHandler handler : ObjectServerChannel.this.handlers) {
                                handler.onReceive(request);
                            }
                        }
                        return;
                    }
                    String username = (String)request.get("USERNAME");
                    String password = (String)request.get("PASSWORD");
                    InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
                    String ip = "";
                    if (address.isUnresolved()) {
                        ip = address.getHostName();
                    } else {
                        ip = address.getAddress().toString();
                        if (ip.charAt(0) == '/') {
                            ip = ip.substring(1);
                        }
                    }
                    ViettelMsg response = request.getResponse();
                    ObjectServerChannel.this.info("authen request[" + username + "," + password + "," + ip + "]");
                    if (ObjectServerChannel.this.authenticator.validate(username, password, ip) && ObjectServerChannel.this.isQuota(ip) && ObjectServerChannel.this.isQuota(username)) {
                        response.setError("0");
                        String sessionKey = String.valueOf(session.getId());
                        ObjectServerChannel.this.sessions.put(session.getId(), session);
                        MdcInjectionFilter.setProperty((IoSession)session, (String)"id", (String)sessionKey);
                        SessionInfor infor = ObjectServerChannel.this.getSessionInfor(username);
                        session.setAttribute((Object)"user", (Object)infor);
                        infor.connect = AbstractViettelChannel.increase(infor.connect, 1L);
                        MdcInjectionFilter.setProperty((IoSession)session, (String)"user", (String)username);
                        infor.requestSend = AbstractViettelChannel.increase(infor.requestSend, 1L);
                        Object object4 = ObjectServerChannel.this.lockReqSend;
                        synchronized (object4) {
                            ObjectServerChannel.this.reqSend = AbstractViettelChannel.increase(ObjectServerChannel.this.reqSend, 1L);
                        }
                        session.write((Object)response);
                        ObjectServerChannel.this.info(username + " login sucessfully");
                    } else {
                        ObjectServerChannel.this.info(username + " login failure");
                        response.setError("1");
                        object3 = ObjectServerChannel.this.lockReqSend;
                        synchronized (object3) {
                            ObjectServerChannel.this.reqSend = AbstractViettelChannel.increase(ObjectServerChannel.this.reqSend, 1L);
                        }
                        session.write((Object)response);
                        session.close(true);
                    }
                    object3 = ObjectServerChannel.this.handlers;
                    synchronized (object3) {
                        for (ViettelChannelHandler handler : ObjectServerChannel.this.handlers) {
                            SessionInfor infor = (SessionInfor)session.getAttribute((Object)"user");
                            if (infor != null) {
                                handler.onLoggedOn(infor.userId, ObjectServerChannel.this.getChannelId());
                                infor.connectedTime = ObjectServerChannel.this.d.format(new Date());
                            }
                            handler.onConnected(session.getId());
                        }
                    }
                }
                if (session.getAttribute((Object)"user") != null) {
                    SessionInfor infor = (SessionInfor)session.getAttribute((Object)"user");
                    infor.received = AbstractViettelChannel.increase(infor.received, 1L);
                    for (ViettelChannelHandler handler : ObjectServerChannel.this.handlers) {
                        InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
                        String ip = "";
                        if (address.isUnresolved()) {
                            ip = address.getHostName();
                        } else {
                            ip = address.getAddress().toString();
                            if (ip.charAt(0) == '/') {
                                ip = ip.substring(1);
                            }
                        }
                        ObjectServerChannel.this.logger.debug((Object)("client: " + ip));
                        request.setProperty("ip", ip);
                        handler.onReceive(request, ObjectServerChannel.this.getChannelId());
                    }
                } else {
                    ObjectServerChannel.this.warn("unlogged session, reject message");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageSent(IoSession session, Object message) throws Exception {
            ObjectServerChannel.this.debug("session[" + session.getId() + "] sent:" + message);
            if (message instanceof ViettelMsg) {
                Object object = ObjectServerChannel.this.lockReqSent;
                synchronized (object) {
                    ObjectServerChannel.this.sent = AbstractViettelChannel.increase(ObjectServerChannel.this.sent, 1L);
                }
                SessionInfor infor = (SessionInfor)session.getAttribute((Object)"user");
                if (infor != null) {
                    infor.sent = AbstractViettelChannel.increase(infor.sent, 1L);
                }
                Set set = ObjectServerChannel.this.handlers;
                synchronized (set) {
                    for (ViettelChannelHandler handler : ObjectServerChannel.this.handlers) {
                        handler.onProcessed((ViettelMsg)message, ObjectServerChannel.this.getChannelId());
                    }
                }
            }
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            ObjectServerChannel.this.debug("session[" + session.getId() + "] idle");
            session.close(true);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            ObjectServerChannel.this.error(cause.getMessage());
            session.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(IoSession session) throws Exception {
            ObjectServerChannel.this.debug("session[" + session.getId() + "] closed");
            ObjectServerChannel.this.sessions.remove(session.getId());
            Set set = ObjectServerChannel.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ObjectServerChannel.this.handlers) {
                    SessionInfor infor = (SessionInfor)session.getAttribute((Object)"user");
                    if (infor != null) {
                        handler.onLoggedOff(infor.userId, ObjectServerChannel.this.getChannelId());
                        infor.disconnect = AbstractViettelChannel.increase(infor.disconnect, 1L);
                    }
                    handler.onDisconnected(session.getId());
                }
            }
        }
    }
}

