/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.AbstractViettelChannel;
import com.viettel.common.OriginalViettelMsg;
import com.viettel.common.ViettelChannelHandler;
import com.viettel.common.ViettelMsg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class ObjectClientChannel
extends AbstractViettelChannel {
    private String name;
    private long systemTrace;
    private static final int CONNECT_TIMEOUT = 30000;
    private NioSocketConnector connector;
    private IoSession session = null;
    private String ip;
    private int port;
    private String username;
    private String password;
    private final boolean syn;
    private final boolean retry;
    private Hashtable<String, ViettelMsg> waitQueue = new Hashtable();
    private final Object lockCheckConnectState = new Object();
    private final Object lockGetSystemTrace = new Object();
    private final Object lockIncreateSendCount = new Object();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ObjectClientChannel() {
        this.syn = false;
        this.retry = true;
        this.channelType = 0;
    }

    public ObjectClientChannel(String ip, int port, String username, String password) {
        this(ip, port, username, password, false, true);
    }

    public ObjectClientChannel(String ip, int port, String username, String password, boolean syn) {
        this(ip, port, username, password, syn, true);
    }

    public ObjectClientChannel(String name, String ip, int port, String username, String password, boolean syn, boolean retry) {
        this.name = name;
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
        this.syn = syn;
        this.retry = retry;
    }

    public ObjectClientChannel(String ip, int port, String username, String password, boolean syn, boolean retry) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
        this.syn = syn;
        this.retry = retry;
        this.channelType = 0;
    }

    public String getInfor() {
        StringBuffer buffer = new StringBuffer("Object Client Channel");
        buffer.append("\r\nRequest Send:" + this.reqSend);
        buffer.append("\r\nSent:" + this.sent);
        buffer.append("\r\nReceived:" + this.received);
        return buffer.toString();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String val) {
        this.username = val;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public boolean isLogged() {
        return this.isConnected() && this.logged;
    }

    protected void setLogged(boolean logged) {
        this.logged = logged;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSyn() {
        return this.syn;
    }

    public boolean isRetry() {
        return this.retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViettelMsg send(ViettelMsg request) throws IOException {
        if (!this.isSyn()) {
            throw new IOException("operation not supported in asyn mode");
        }
        Object object = this.lockCheckConnectState;
        synchronized (object) {
            if (!this.isLogged()) {
                if (!this.isRetry()) {
                    throw new IOException("channel isn't logged");
                }
                this.reconnect2();
                if (!this.isLogged()) {
                    throw new IOException("can't not connect channel, retry failure");
                }
            }
        }
        return this.isend(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViettelMsg isend(ViettelMsg request) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("channel isn't connected");
        }
        Object object = this.lockIncreateSendCount;
        synchronized (object) {
            this.reqSend = ObjectClientChannel.increase(this.reqSend, 1L);
        }
        request.setClientId(this.getUsername());
        long receiveTimeout = this.getReceiverTimeout();
        if (receiveTimeout == 0L) {
            receiveTimeout = 60000L;
        }
        request.set("ClientTimeout", receiveTimeout);
        if (request.getSystemTrace() == 0L) {
            Object object2 = this.lockGetSystemTrace;
            synchronized (object2) {
                this.systemTrace = ObjectClientChannel.increase(this.systemTrace, 1L);
                request.setSystemTrace(this.systemTrace);
            }
        }
        String reqMsgKey = "SENT_" + request.getClientId() + "_" + request.getSystemTrace();
        String resMsgKey = "RECV_" + request.getClientId() + "_" + request.getSystemTrace();
        if (this.waitQueue.containsKey(reqMsgKey)) {
            throw new IOException("message with same system trace is sendding");
        }
        request.setProperty("TYPE", "SENT");
        this.waitQueue.put(reqMsgKey, request);
        WriteFuture future = this.session.write((Object)request);
        if (future.getException() != null) {
            this.waitQueue.remove(reqMsgKey);
            this.waitQueue.remove(resMsgKey);
            throw new IOException("channel is closing or disconnected");
        }
        try {
            int REACHED = 1;
            int i = 0;
            ViettelMsg viettelMsg = request;
            synchronized (viettelMsg) {
                while (!this.waitQueue.containsKey(resMsgKey) && i++ < REACHED) {
                    this.debug(Thread.currentThread().getName() + " wait for " + request.hashCode());
                    request.wait(this.getReceiverTimeout());
                }
            }
            ViettelMsg response = this.waitQueue.get(resMsgKey);
            if (response == null) {
                throw new IOException("send message timeout");
            }
            response.setProperty("CHANNEL", this.session.getId());
            ViettelMsg viettelMsg2 = response;
            return viettelMsg2;
        }
        catch (InterruptedException ex) {
            throw new IOException("send message timeout:" + ex);
        }
        finally {
            this.waitQueue.remove(reqMsgKey);
            this.waitQueue.remove(resMsgKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsyn(ViettelMsg request) throws IOException {
        if (this.isSyn()) {
            throw new IOException("operation not supported in syn mode");
        }
        Object object = this.lockCheckConnectState;
        synchronized (object) {
            if (!this.isLogged()) {
                if (!this.isRetry()) {
                    throw new IOException("channel isn't logged");
                }
                this.reconnect2();
                if (!this.isLogged()) {
                    throw new IOException("can't not connect channel, retry failure");
                }
            }
        }
        object = this.lockIncreateSendCount;
        synchronized (object) {
            this.reqSend = ObjectClientChannel.increase(this.reqSend, 1L);
        }
        if (request.getSystemTrace() == 0L) {
            object = this.lockGetSystemTrace;
            synchronized (object) {
                this.systemTrace = ObjectClientChannel.increase(this.systemTrace, 1L);
                request.setSystemTrace(this.systemTrace);
            }
        }
        request.setClientId(this.username);
        WriteFuture future = this.session.write((Object)request);
        if (future.getException() != null) {
            throw new IOException("channel is closing or disconnected");
        }
    }

    public void connect() throws IOException {
        this.connector = new NioSocketConnector();
        this.connector.setConnectTimeoutMillis(30000L);
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.connector.setHandler((IoHandler)new ClientSessionHandler());
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.ip, this.port));
        future = future.awaitUninterruptibly();
        try {
            this.session = future.getSession();
            this.info("connected to server");
        }
        catch (Exception ex) {
            throw new IOException("can't connect to server");
        }
        if (this.session == null) {
            throw new IOException("can't connect to server");
        }
        this.login();
        this.connected = true;
    }

    public void reconnect2() throws IOException {
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.connector.setConnectTimeoutMillis(30000L);
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
            this.connector.setHandler((IoHandler)new ClientSessionHandler());
        }
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.ip, this.port));
        future = future.awaitUninterruptibly();
        try {
            this.session = future.getSession();
            this.info("connected to server");
        }
        catch (Exception ex) {
            throw new IOException("can't connect to server");
        }
        if (this.session == null) {
            throw new IOException("can't connect to server");
        }
        this.login();
        this.connected = true;
    }

    public void disconnect() throws IOException {
        if (this.isConnected()) {
            this.session.close(true);
        }
        if (this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
        this.session = null;
    }

    public void reconnect() throws IOException {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (!this.isConnected()) {
            this.connect();
        }
    }

    private void login() throws IOException {
        OriginalViettelMsg request = new OriginalViettelMsg();
        request.setCommand("AUTHEN");
        request.setClientId(this.username);
        request.set("USERNAME", this.username);
        request.set("PASSWORD", this.password);
        this.info(request.toString());
        ViettelMsg response = this.isend(request);
        this.info(response.toString());
        if ("0".equals(response.getError())) {
            this.setLogged(true);
        }
    }

    public void setChannelType(int channelType) {
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        Vector<MBeanAttributeInfo> v = new Vector<MBeanAttributeInfo>();
        v.add(new MBeanAttributeInfo("Host", "java.lang.String", "The remote hostname", true, false, false));
        v.add(new MBeanAttributeInfo("Port", "java.lang.Integer", "The listening port", true, false, false));
        v.add(new MBeanAttributeInfo("Username", "java.lang.String", "The channel username", true, false, false));
        v.add(new MBeanAttributeInfo("Password", "java.lang.String", "The channel password", true, false, false));
        v.add(new MBeanAttributeInfo("Synchronous", "java.lang.Boolean", "The synchronous mode", true, false, false));
        v.add(new MBeanAttributeInfo("Retryable", "java.lang.Boolean", "The retryable value, channel 'll try send again when send message fail in rety mode", true, false, false));
        v.add(new MBeanAttributeInfo("ReceiverTimeout", "java.lang.Integer", "The receiver timeout value", true, false, false));
        return v.toArray(new MBeanAttributeInfo[v.size()]);
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attribute_name.equals("Host")) {
            return this.ip;
        }
        if (attribute_name.equals("Port")) {
            return this.port;
        }
        if (attribute_name.equals("Username")) {
            return this.username;
        }
        if (attribute_name.equals("Password")) {
            return this.password;
        }
        if (attribute_name.equals("Synchronous")) {
            return this.isSyn();
        }
        if (attribute_name.equals("Retryable")) {
            return this.isRetry();
        }
        if (attribute_name.equals("ReceiverTimeout")) {
            return this.getReceiverTimeout();
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.dClassName);
    }

    class ClientSessionHandler
    extends IoHandlerAdapter {
        private static final int IDLE_TIME = 900;

        ClientSessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionOpened(IoSession session) throws Exception {
            session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 900);
            ObjectClientChannel.this.debug("session[" + session.getId() + "] opened");
            Set set = ObjectClientChannel.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                    handler.onConnected(session.getId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoSession session, Object message) {
            block17: {
                ObjectClientChannel.this.debug("session[" + session.getId() + "] received:" + message);
                if (!(message instanceof ViettelMsg)) break block17;
                ObjectClientChannel.this.received = AbstractViettelChannel.increase(ObjectClientChannel.this.received, 1L);
                ViettelMsg response = (ViettelMsg)message;
                if ("AUTHEN".equals(response.getCommand())) {
                    response.setProperty("TYPE", "RECEIVED");
                    String reqMsgKey = "SENT_" + response.getClientId() + "_" + response.getSystemTrace();
                    String resMsgKey = "RECV_" + response.getClientId() + "_" + response.getSystemTrace();
                    ViettelMsg request = (ViettelMsg)ObjectClientChannel.this.waitQueue.get(reqMsgKey);
                    if (request != null) {
                        ObjectClientChannel.this.waitQueue.put(resMsgKey, response);
                        ViettelMsg viettelMsg = request;
                        synchronized (viettelMsg) {
                            ObjectClientChannel.this.debug(Thread.currentThread().getName() + " notify " + request.hashCode());
                            request.notifyAll();
                        }
                    } else {
                        ObjectClientChannel.this.debug("request store is null, can't notify, report timeout to handler");
                        for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                            handler.onReceive(response, ObjectClientChannel.this.getChannelId());
                        }
                    }
                    if ("0".equals(response.getError())) {
                        ObjectClientChannel.this.setLogged(true);
                    }
                    return;
                }
                if (ObjectClientChannel.this.isSyn()) {
                    response.setProperty("TYPE", "RECEIVED");
                    String reqMsgKey = "SENT_" + response.getClientId() + "_" + response.getSystemTrace();
                    String resMsgKey = "RECV_" + response.getClientId() + "_" + response.getSystemTrace();
                    ViettelMsg request = (ViettelMsg)ObjectClientChannel.this.waitQueue.get(reqMsgKey);
                    if (request != null) {
                        ObjectClientChannel.this.waitQueue.put(resMsgKey, response);
                        ViettelMsg i$ = request;
                        synchronized (i$) {
                            ObjectClientChannel.this.debug(Thread.currentThread().getName() + " notify " + request.hashCode());
                            request.notifyAll();
                        }
                    } else {
                        ObjectClientChannel.this.debug("request store is null, can't notify, report timeout to handler");
                        for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                            handler.onReceive(response, ObjectClientChannel.this.getChannelId());
                        }
                    }
                } else {
                    for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                        handler.onReceive(response, ObjectClientChannel.this.getChannelId());
                    }
                }
            }
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            ObjectClientChannel.this.debug("session[" + ObjectClientChannel.this.getChannelId() + "] sent:" + message);
            if (message instanceof ViettelMsg) {
                ObjectClientChannel.this.sent = AbstractViettelChannel.increase(ObjectClientChannel.this.sent, 1L);
                ViettelMsg request = (ViettelMsg)message;
                if (!ObjectClientChannel.this.isSyn()) {
                    for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                        handler.onProcessed(request, session.getId());
                    }
                }
            }
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            ObjectClientChannel.this.debug("session[" + ObjectClientChannel.this.getChannelId() + "] idle");
            session.close(true);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            ObjectClientChannel.this.error(cause.getMessage());
            if (cause instanceof IOException) {
                session.close(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(IoSession session) throws Exception {
            ObjectClientChannel.this.debug("session[" + ObjectClientChannel.this.getChannelId() + "] closed");
            Object object = ObjectClientChannel.this.waitQueue;
            synchronized (object) {
                Iterator<Object> i$ = ObjectClientChannel.this.waitQueue.values().iterator();
                while (i$.hasNext()) {
                    ViettelMsg msg;
                    ViettelMsg viettelMsg = msg = (ViettelMsg)i$.next();
                    synchronized (viettelMsg) {
                        ObjectClientChannel.this.debug(Thread.currentThread().getName() + " notify " + msg.hashCode());
                        msg.notifyAll();
                    }
                }
            }
            object = ObjectClientChannel.this.handlers;
            synchronized (object) {
                for (ViettelChannelHandler handler : ObjectClientChannel.this.handlers) {
                    handler.onDisconnected(session.getId());
                }
            }
        }
    }
}

