/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.AbstractViettelChannel;
import com.viettel.common.ViettelChannel;
import com.viettel.common.ViettelChannelHandler;
import com.viettel.common.ViettelHandlerAdapter;
import com.viettel.common.ViettelMsg;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelGroup
extends AbstractViettelChannel {
    protected final Set<ViettelChannel> channels = Collections.synchronizedSet(new HashSet());
    private ViettelChannelHandler handler = new GroupChannelHander();

    public ChannelGroup() {
        this.registerAgent("channels:type=" + this.getClass().getSimpleName());
    }

    @Override
    public String getInfor() {
        StringBuffer buffer = new StringBuffer("ChannelGroup");
        for (ViettelChannel channel : this.channels) {
            buffer.append("\r\n");
            buffer.append(channel.getInfor());
        }
        return buffer.toString();
    }

    public boolean addChannel(ViettelChannel channel) {
        if (channel == null) {
            return false;
        }
        if (this.findChannel(channel.getChannelId()) != null) {
            return false;
        }
        channel.addHandler(this.handler);
        return this.channels.add(channel);
    }

    public Set<ViettelChannel> getChannels() {
        return this.channels;
    }

    public boolean removeChannel(long channelId) {
        ViettelChannel channel = this.findChannel(channelId);
        if (channel != null) {
            return this.channels.remove(channel);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViettelChannel findChannel(long channelId) {
        Set<ViettelChannel> set = this.channels;
        synchronized (set) {
            for (ViettelChannel channel : this.channels) {
                if (channel.getChannelId() != channelId) continue;
                return channel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViettelMsg send(ViettelMsg request) throws IOException {
        if (this.getChannelType() == 1) {
            if (!request.hasProperty("channel-" + this.getChannelId())) {
                throw new IOException("message without channel properties");
            }
            long gChannelId = (Long)request.getProperty("channel-" + this.getChannelId());
            ViettelChannel channel = this.findChannel(gChannelId);
            if (channel == null) {
                throw new IOException("channel [" + gChannelId + "] not found");
            }
            return channel.send(request);
        }
        if (request.hasProperty("channel-" + this.getChannelId())) {
            long gChannelId = (Long)request.getProperty("channel-" + this.getChannelId());
            ViettelChannel channel = this.findChannel(gChannelId);
            if (channel == null) {
                throw new IOException("channel [" + gChannelId + "] not found");
            }
            return channel.send(request);
        }
        ViettelChannel channel = null;
        long reqMsg = Long.MAX_VALUE;
        Set<ViettelChannel> set = this.channels;
        synchronized (set) {
            for (ViettelChannel c : this.channels) {
                if (c.getRequestMesssage() >= reqMsg) continue;
                reqMsg = c.getRequestMesssage();
                channel = c;
            }
        }
        if (channel == null) {
            throw new IOException("no channel found.");
        }
        return channel.send(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAsyn(ViettelMsg request) throws IOException {
        if (this.getChannelType() == 1) {
            if (!request.hasProperty("channel-" + this.getChannelId())) {
                throw new IOException("message without channel properties");
            }
            long gChannelId = (Long)request.getProperty("channel-" + this.getChannelId());
            ViettelChannel channel = this.findChannel(gChannelId);
            if (channel == null) {
                throw new IOException("channel [" + gChannelId + "] not found");
            }
            channel.sendAsyn(request);
        } else if (request.hasProperty("channel-" + this.getChannelId())) {
            long gChannelId = (Long)request.getProperty("channel-" + this.getChannelId());
            ViettelChannel channel = this.findChannel(gChannelId);
            if (channel == null) {
                throw new IOException("channel [" + gChannelId + "] not found");
            }
            channel.sendAsyn(request);
        } else {
            ViettelChannel channel = null;
            long reqMsg = Long.MAX_VALUE;
            Set<ViettelChannel> set = this.channels;
            synchronized (set) {
                for (ViettelChannel c : this.channels) {
                    if (c.getRequestMesssage() >= reqMsg) continue;
                    reqMsg = c.getRequestMesssage();
                    channel = c;
                }
            }
            if (channel == null) {
                throw new IOException("message without channel properties");
            }
            channel.sendAsyn(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        Set<ViettelChannel> set = this.channels;
        synchronized (set) {
            for (ViettelChannel channel : this.channels) {
                String objectName = "channels:type=" + this.getClass().getSimpleName() + "-" + this.getChannelId() + ",name=" + channel.getClass().getSimpleName();
                if (channel instanceof AbstractViettelChannel) {
                    ((AbstractViettelChannel)channel).registerAgent(objectName);
                }
                channel.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        Set<ViettelChannel> set = this.channels;
        synchronized (set) {
            for (ViettelChannel channel : this.channels) {
                channel.disconnect();
                String objectName = "channels:type=" + this.getClass().getSimpleName() + "-" + this.getChannelId() + ",name=" + channel.getClass().getSimpleName();
                if (!(channel instanceof AbstractViettelChannel)) continue;
                ((AbstractViettelChannel)channel).unregisterAgent(objectName);
            }
        }
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        for (ViettelChannel channel : this.channels) {
            channel.setLogger(logger);
        }
    }

    protected void finalize() throws Throwable {
        this.unregisterAgent("channels:type=" + this.getClass().getSimpleName());
        super.finalize();
    }

    class GroupChannelHander
    extends ViettelHandlerAdapter {
        GroupChannelHander() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(long channelId) {
            ChannelGroup.this.debug("channel group on connected:" + channelId);
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onConnected(channelId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(long channelId) {
            ChannelGroup.this.debug("channel group on disconnected:" + channelId);
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onConnected(channelId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoggedOff(String userId, long channelId) {
            ChannelGroup.this.debug("channel group on logged off[" + userId + "," + channelId + "]");
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onLoggedOff(userId, channelId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoggedOn(String userId, long channelId) {
            ChannelGroup.this.debug("channel group on logged on[" + userId + "," + channelId + "]");
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onLoggedOn(userId, channelId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessed(ViettelMsg msg, long channelId) {
            ChannelGroup.this.debug("channel group on processed[" + channelId + "] msg:" + msg);
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onProcessed(msg, channelId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(ViettelMsg msg, long channelId) {
            ChannelGroup.this.debug("channel group on received[" + channelId + "] msg:" + msg);
            msg.setProperty("channel-" + ChannelGroup.this.getChannelId(), channelId);
            Set set = ChannelGroup.this.handlers;
            synchronized (set) {
                for (ViettelChannelHandler handler : ChannelGroup.this.handlers) {
                    handler.onReceive(msg, channelId);
                }
            }
        }
    }
}

