/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.warnning;

import com.viettel.mmserver.base.ConfigParam;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.mmserver.database.DatabaseAccessor;
import java.util.ArrayList;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class ErrorDefinitionHandler
extends ProcessThreadMX {
    private static final int SLEEP_TIME = 1000;
    private DatabaseAccessor dbAccessor = null;
    private static ErrorDefinitionHandler sharedInstance = null;
    private static String mBeanName = "Tools:name=ErrorDefinitionHandler";
    private String appId = "";
    public static final String NOTIFICATION_TYPE = "errorDefiniton.change";

    public static synchronized ErrorDefinitionHandler getInstance() {
        if (sharedInstance == null) {
            try {
                sharedInstance = new ErrorDefinitionHandler();
            }
            catch (Exception ex) {
                Log.error("Critical error when init an instance of ErrorDefinitionHandler" + ex.getMessage());
                throw new RuntimeException("Critical error when init an instance of ErrorDefinitionHandler!");
            }
        }
        return sharedInstance;
    }

    private ErrorDefinitionHandler() throws NotCompliantMBeanException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException {
        super("Error Definition Handler");
        this.registerAgent(mBeanName);
        this.appId = ConfigParam.getInstance().loadAppId();
        this.logger.info((Object)"Created an instance of ErrorDefinitionHandler");
    }

    protected void process() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public int addErrorDefinition(String userName, Boolean useFlag, String logLevel, String loggerName, String message, String threadName, String smsFormat, String smsContent, boolean sendSMS, String errorFrequence) {
        int errorID;
        if (this.dbAccessor == null) {
            this.dbAccessor = DatabaseAccessor.shareInstance();
        }
        if ((errorID = this.dbAccessor.insertErrorDefinition(this.appId, userName, new Date(), useFlag, logLevel, loggerName, message, threadName, smsFormat, smsContent, sendSMS, errorFrequence)) > 0) {
            Notification notification = new Notification(NOTIFICATION_TYPE, (Object)errorID, 0L, "add");
            this.notificationHandler.sendNotification(notification);
        }
        return errorID;
    }

    public int sendSMSTo(String appID, String phoneNumList) {
        if (this.dbAccessor == null) {
            this.dbAccessor = DatabaseAccessor.shareInstance();
        }
        if (phoneNumList.equals("")) {
            this.dbAccessor.deleteApplicationReceiver(appID);
            this.dbAccessor.deleleReceiver(appID);
            return 1;
        }
        this.dbAccessor.deleleReceiver(appID);
        return this.dbAccessor.insertReceiver(appID, phoneNumList);
    }

    public int removeErrorDefiniton(int errorID) {
        int ierrorID;
        if (this.dbAccessor == null) {
            this.dbAccessor = DatabaseAccessor.shareInstance();
        }
        if ((ierrorID = this.dbAccessor.deleteErrorDefinition(errorID)) > 0) {
            Notification notification = new Notification(NOTIFICATION_TYPE, (Object)ierrorID, 0L, "remove");
            this.notificationHandler.sendNotification(notification);
        }
        return ierrorID;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("addErrorDefinition")) {
            return this.addErrorDefinition((String)params[0], (Boolean)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], (String)params[6], (String)params[7], (Boolean)params[8], (String)params[9]);
        }
        if (operationName.equals("removeErrorDefinition")) {
            return this.removeErrorDefiniton((Integer)params[0]);
        }
        if (operationName.equals("sendSMSTo")) {
            return this.sendSMSTo((String)params[0], (String)params[1]);
        }
        return super.invoke(operationName, params, signature);
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("userName", "java.lang.String", ""), new MBeanParameterInfo("useFlag", "java.lang.Boolean", ""), new MBeanParameterInfo("logLevel", "java.lang.String", ""), new MBeanParameterInfo("loggerName", "java.lang.String", ""), new MBeanParameterInfo("message", "java.lang.String", ""), new MBeanParameterInfo("threadName", "java.lang.String", ""), new MBeanParameterInfo("smsFormat", "java.lang.String", ""), new MBeanParameterInfo("smsContent", "java.lang.String", ""), new MBeanParameterInfo("sendSMS", "java.lang.Boolean", ""), new MBeanParameterInfo("errorFrequence", "java.lang.String", "")};
        v.add(new MBeanOperationInfo("addErrorDefinition", "add a new ErrorDefinition", params, "int", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("errorID", "java.lang.Integer", "")};
        v.add(new MBeanOperationInfo("removeErrorDefinition", "remove an ErrorDefinition", params, "int", 1));
        v.add(new MBeanOperationInfo("sendSMSTo", "remove an ErrorDefinition", params, "int", 1));
        MBeanOperationInfo[] old = super.buildOperations();
        for (int i = 0; i < old.length; ++i) {
            v.add(old[i]);
        }
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }
}

