/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.log.appender;

import com.viettel.mmserver.log.appender.AppenderThreadMX;
import com.viettel.mmserver.log.appender.SocketWriterManager;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketWriter
extends AppenderThreadMX {
    public static final int SLEEP_TIME = 1000;
    private ObjectOutputStream oos;
    private int maxQueue = 1000;
    private List<LoggingEvent> logQueue = new LinkedList<LoggingEvent>();
    private final Object queueLock = new Object();
    private String clientDescription = "";
    private long count = 0L;
    private SocketWriterManager swm;

    public void setSwm(SocketWriterManager swm) {
        this.swm = swm;
    }

    public SocketWriter(ObjectOutputStream oos, int maxQueue, int id, String clientDescription) {
        super("SocketWriter" + id);
        if (oos != null && id >= 0) {
            this.oos = oos;
            this.setId(id);
            if (maxQueue > 0) {
                this.maxQueue = maxQueue;
            }
            if (clientDescription != null && !clientDescription.equals("")) {
                this.clientDescription = clientDescription;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(LoggingEvent event) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.logQueue.size() < this.maxQueue) {
                this.logQueue.add(event);
            } else {
                this.logQueue.remove(0);
                this.logQueue.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfor() {
        String info = "";
        info = "Client: " + this.clientDescription;
        Object object = this.queueLock;
        synchronized (object) {
            info = info + "\nCurrent queue size: " + this.logQueue.size();
        }
        info = info + "\nWriten logs: " + this.count;
        return info;
    }

    public void flushOfflineQueue(List<LoggingEvent> offlineLogQueue) throws IOException {
        if (this.oos != null && offlineLogQueue != null) {
            for (LoggingEvent event : offlineLogQueue) {
                this.oos.writeObject(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        LoggingEvent event = null;
        event = null;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.logQueue.size() > 0) {
                event = this.logQueue.remove(0);
            }
        }
        if (event != null && this.oos != null) {
            try {
                this.oos.writeObject(event);
                this.oos.flush();
                this.oos.reset();
                ++this.count;
                this.count %= Long.MAX_VALUE;
            }
            catch (Throwable e) {
                this.swm.removeSocketWriter(this.getId());
                this.releaseResouce();
            }
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable ex) {
                System.out.println(ex);
            }
        }
    }

    public void releaseResouce() {
        this.running = false;
        this.logQueue = null;
        try {
            this.oos.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

