/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.database;

import com.viettel.mmserver.database.ConnectionException;
import com.viettel.mmserver.database.DataSource;
import com.viettel.mmserver.database.Param;
import com.viettel.mmserver.database.ParamList;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class DataStore {
    public final int BUFSIZE = 1024;
    protected Logger logger;
    protected Connection connection;
    protected Statement stmt;
    protected boolean pooling;
    protected String cnString;
    protected String username;
    protected String password;
    protected String sqlcheck;
    protected final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataStore(String configFile) throws ClassNotFoundException, SQLException, FileNotFoundException, IOException {
        FileReader r = null;
        try {
            r = new FileReader(configFile);
            Properties properties = new Properties();
            properties.load(r);
            String dbdriver = properties.getProperty("driver");
            String dbconnStr = properties.getProperty("connection");
            String dbusername = properties.getProperty("username");
            String dbpassword = properties.getProperty("password");
            String dbsqlcheck = properties.getProperty("sqlcheck", "select 1 from dual");
            boolean dbpooling = "true".equals(properties.getProperty("pooling", "false"));
            this.init(dbdriver, dbconnStr, dbusername, dbpassword, dbsqlcheck, dbpooling);
            Object var11_10 = null;
            if (r == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException ex) {
                this.logger.error((Object)("close buffer reader exception:" + ex));
            }
            throw throwable;
        }
        try {
            r.close();
            return;
        }
        catch (IOException ex) {
            this.logger.error((Object)("close buffer reader exception:" + ex));
        }
    }

    public DataStore(Properties properties) throws ClassNotFoundException, SQLException {
        String dbdriver = properties.getProperty("driver");
        String dbconnStr = properties.getProperty("connection");
        String dbusername = properties.getProperty("username");
        String dbpassword = properties.getProperty("password");
        String dbsqlcheck = properties.getProperty("sqlcheck", "select 1 from dual");
        boolean dbpooling = "true".equals(properties.getProperty("pooling", "false"));
        this.init(dbdriver, dbconnStr, dbusername, dbpassword, dbsqlcheck, dbpooling);
    }

    public DataStore(String driver, String cnString, String username, String password, String sqlcheck) throws ClassNotFoundException, SQLException {
        this.init(driver, cnString, username, password, sqlcheck, false);
    }

    public DataStore(String driver, String cnString, String username, String password, String sqlcheck, boolean pooling) throws ClassNotFoundException, SQLException {
        this.init(driver, cnString, username, password, sqlcheck, pooling);
    }

    private void init(String driver, String cnString, String username, String password, String sqlcheck, boolean pooling) throws ClassNotFoundException, SQLException {
        this.logger = Logger.getLogger((String)"datastore");
        if (driver == null || cnString == null || username == null || password == null) {
            throw new NullPointerException("One of mandatory parameter is null");
        }
        if (sqlcheck == null) {
            sqlcheck = "select 1 from dual";
        }
        try {
            this.logger.info((Object)("instance driver:" + driver));
            Class.forName(driver);
            this.pooling = pooling;
            this.cnString = cnString;
            this.username = username;
            this.password = password;
            this.sqlcheck = sqlcheck;
            if (pooling) {
                this.logger.info((Object)"instance pool");
                this.instancePool(cnString, username, password);
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String cnString, String username, String password, boolean pooling) {
        Object object = this.lock;
        synchronized (object) {
            if (!(this.cnString.equals(cnString) && this.username.equals(username) && this.password.equals(password))) {
                this.cnString = cnString;
                this.username = username;
                this.password = password;
                if (this.connection != null) {
                    try {
                        try {
                            this.connection.close();
                        }
                        catch (SQLException ex) {
                            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                            Object var8_7 = null;
                            this.connection = null;
                        }
                        Object var8_6 = null;
                        this.connection = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.connection = null;
                        throw throwable;
                    }
                }
                if (this.pooling) {
                    try {
                        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
                        if (driver != null) {
                            driver.closePool("pool");
                        }
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            this.pooling = pooling;
            if (pooling) {
                try {
                    this.instancePool(cnString, username, password);
                }
                catch (ClassNotFoundException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (SQLException ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void instancePool(String cnString, String username, String password) throws ClassNotFoundException, SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, 10);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(cnString, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool("pool", (ObjectPool)connectionPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.stmt != null) {
                    this.logger.info((Object)"close statement");
                    this.stmt.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("close statement error:" + ex.getMessage()));
            }
            try {
                if (this.connection != null) {
                    this.logger.info((Object)"close connection");
                    this.connection.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (this.pooling) {
                    this.logger.info((Object)"close connection pool");
                    PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
                    driver.closePool("pool");
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("close pool exception: " + ex.getMessage()));
            }
        }
    }

    public int doUpdate(String sql) throws SQLException, ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug((Object)sql);
            PreparedStatement cstmt = null;
            if (this.connection == null) {
                this.logger.info((Object)"the connection is null, create connection");
                this.connection = this.connection();
            }
            try {
                cstmt = this.connection.prepareStatement(sql);
                int r = cstmt.executeUpdate();
                cstmt.close();
                return r;
            }
            catch (SQLException e) {
                this.logger.error((Object)"update database error");
                if (cstmt != null) {
                    try {
                        this.logger.info((Object)"close open statement");
                        cstmt.close();
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)("close statement error:" + ex));
                    }
                }
                this.logger.info((Object)"validate the connection now, may be it has been closed");
                this.validate();
                throw e;
            }
        }
    }

    public ResultSet doQuery(String sql) throws SQLException, ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug((Object)sql);
            if (this.connection == null) {
                this.logger.info((Object)"the connection is null, create connection");
                this.connection = this.connection();
            }
            try {
                return this.stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                this.logger.error((Object)"execute query error");
                this.logger.info((Object)"validate the connection now, may be it has been closed");
                this.validate();
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public DataSource[] retrieveData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            int i;
            if (param == null || param.size() == 0) {
                return 0;
            }
            Param[] pin = param.paramIn();
            Param[] pout = param.paramOut();
            if (pout == null || pout.length == 0) {
                return 0;
            }
            StringBuffer bufsql = new StringBuffer();
            bufsql.append("UPDATE ");
            bufsql.append(table);
            bufsql.append(" SET ");
            for (i = 0; i < pout.length; ++i) {
                bufsql.append(pout[i].getName());
                bufsql.append('=');
                if (pout[i].getDatatype().equals("string")) {
                    bufsql.append('\'');
                    bufsql.append(pout[i].getValue());
                    bufsql.append('\'');
                } else {
                    bufsql.append(pout[i].getValue());
                }
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            if (pin != null && pin.length > 0) {
                bufsql.append(" WHERE ");
                for (i = 0; i < pin.length; ++i) {
                    bufsql.append(pin[i].getName());
                    bufsql.append('=');
                    if (pin[i].getDatatype().equals("string")) {
                        bufsql.append('\'');
                        bufsql.append(pin[i].getValue());
                        bufsql.append('\'');
                    } else {
                        bufsql.append(pin[i].getValue());
                    }
                    if (i == pin.length - 1) continue;
                    bufsql.append(" AND ");
                }
            }
            String sql = bufsql.toString();
            return this.doUpdate(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            int i;
            if (param == null || param.size() == 0) {
                return 0;
            }
            Param[] pout = param.paramOut();
            if (pout == null || pout.length == 0) {
                return 0;
            }
            StringBuffer bufsql = new StringBuffer();
            bufsql.append("INSERT INTO ");
            bufsql.append(table);
            bufsql.append('(');
            for (i = 0; i < pout.length; ++i) {
                bufsql.append(pout[i].getName());
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            bufsql.append(") VALUES (");
            for (i = 0; i < pout.length; ++i) {
                if (pout[i].getDatatype().equals("string")) {
                    bufsql.append('\'');
                    bufsql.append(pout[i].getValue());
                    bufsql.append('\'');
                } else {
                    bufsql.append(pout[i].getValue());
                }
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            bufsql.append(')');
            String sql = bufsql.toString();
            return this.doUpdate(sql);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertData(ParamList[] param, String table) throws SQLException, IOException, ConnectionException {
        var3_3 = this.lock;
        synchronized (var3_3) {
            block24: {
                if (param == null) return 0;
                if (param.length == 0) {
                    return 0;
                }
                if (this.connection == null) {
                    this.logger.info((Object)"the connection is null, create connection");
                    this.connection = this.connection();
                }
                pstmt = null;
                exception = null;
                try {
                    try {
                        bufsql = new StringBuffer();
                        bufvl = new StringBuffer();
                        bufsql.append("INSERT INTO ");
                        bufsql.append(table);
                        bufsql.append('(');
                        bufvl.append(") VALUES (");
                        for (i = 0; i < param[0].size(); ++i) {
                            bufsql.append(param[0].allParam()[i].getName());
                            bufvl.append('?');
                            if (i == param[0].size() - 1) continue;
                            bufsql.append(',');
                            bufvl.append(',');
                        }
                        bufvl.append(')');
                        bufsql.append(bufvl);
                        sql = bufsql.toString();
                        this.logger.debug((Object)sql);
                        pstmt = this.connection.prepareStatement(sql);
                        for (ParamList p : param) {
                            pout = p.paramOut();
                            if (pout == null || pout.length == 0) continue;
                            for (i = 1; i <= pout.length; ++i) {
                                type = pout[i - 1].getDatatype();
                                value = pout[i - 1].getValue();
                                if (type.equals("byte")) {
                                    pstmt.setByte(i, (Byte)value);
                                    continue;
                                }
                                if (type.equals("short")) {
                                    pstmt.setShort(i, (Short)value);
                                    continue;
                                }
                                if (type.equals("int")) {
                                    pstmt.setInt(i, (Integer)value);
                                    continue;
                                }
                                if (type.equals("long")) {
                                    pstmt.setLong(i, (Long)value);
                                    continue;
                                }
                                if (type.equals("float")) {
                                    pstmt.setFloat(i, ((Float)value).floatValue());
                                    continue;
                                }
                                if (type.equals("double")) {
                                    pstmt.setDouble(i, (Double)value);
                                    continue;
                                }
                                if (type.equals("boolean")) {
                                    pstmt.setBoolean(i, (Boolean)value);
                                    continue;
                                }
                                if (type.equals("date")) {
                                    pstmt.setDate(i, (Date)value);
                                    continue;
                                }
                                if (!type.equals("string")) continue;
                                pstmt.setString(i, (String)value);
                            }
                            pstmt.addBatch();
                        }
                        result = pstmt.executeBatch().length;
                        pstmt.close();
                        var10_13 = result;
                        var18_20 = null;
                        if (pstmt == null) break block24;
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"insert data error");
                        exception = e;
                        throw e;
                    }
                }
                catch (Throwable var17_24) {
                    var18_21 = null;
                    if (pstmt != null) {
                        try {
                            this.logger.info((Object)"close open prepare statement");
                            pstmt.close();
                        }
                        catch (SQLException ex) {
                            this.logger.error((Object)("close statement error:" + ex));
                        }
                    }
                    if (exception == null) throw var17_24;
                    this.logger.info((Object)"validate the connection now, may be it has been closed");
                    this.validate();
                    throw var17_24;
                }
                ** try [egrp 3[TRYBLOCK] [3 : 642->661)] { 
lbl104:
                // 1 sources

                this.logger.info((Object)"close open prepare statement");
                pstmt.close();
                break block24;
lbl107:
                // 1 sources

                catch (SQLException ex) {
                    this.logger.error((Object)("close statement error:" + ex));
                }
            }
            if (exception == null) return var10_13;
            this.logger.info((Object)"validate the connection now, may be it has been closed");
            this.validate();
            return var10_13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException, ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isPooling()) {
                return DriverManager.getConnection("jdbc:apache:commons:dbcp:pool");
            }
            return this.check(this.connection) ? this.connection : this.connection();
        }
    }

    public Connection connection() throws ConnectionException {
        try {
            this.logger.info((Object)"create new connetion");
            this.logger.info((Object)("connection url: " + this.cnString));
            this.logger.info((Object)"connecting ...");
            this.connection = DriverManager.getConnection(this.cnString, this.username, this.password);
            this.stmt = this.connection.createStatement();
            this.logger.info((Object)"connected");
            return this.connection;
        }
        catch (SQLException ex) {
            this.logger.error((Object)"create connection error");
            this.connection = null;
            throw new ConnectionException(ex.getMessage(), this.cnString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean check(Connection conn) {
        if (conn != null) {
            SQLException ex222;
            boolean bl;
            ResultSet rs;
            Statement cstmt;
            block17: {
                cstmt = null;
                rs = null;
                this.logger.info((Object)"check connection");
                this.logger.debug((Object)this.sqlcheck);
                cstmt = conn.prepareStatement(this.sqlcheck);
                rs = cstmt.executeQuery();
                this.logger.info((Object)"connection is ok");
                cstmt.close();
                cstmt = null;
                rs.close();
                rs = null;
                bl = true;
                Object var7_6 = null;
                if (rs == null) break block17;
                try {
                    rs.close();
                }
                catch (SQLException ex222) {
                    this.logger.error((Object)("close result set error:" + ex222));
                }
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (SQLException ex222) {
                    this.logger.error((Object)("close statement error:" + ex222));
                }
            }
            return bl;
            catch (SQLException ex3) {
                SQLException ex222;
                boolean bl2;
                block19: {
                    try {
                        this.logger.info((Object)("connection is broken down:" + ex3.getMessage()));
                        bl2 = false;
                        Object var7_7 = null;
                        if (rs == null) break block19;
                    }
                    catch (Throwable throwable) {
                        SQLException ex222;
                        Object var7_8 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ex222) {
                                this.logger.error((Object)("close result set error:" + ex222));
                            }
                        }
                        if (cstmt != null) {
                            try {
                                cstmt.close();
                            }
                            catch (SQLException ex222) {
                                this.logger.error((Object)("close statement error:" + ex222));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException ex222) {
                        this.logger.error((Object)("close result set error:" + ex222));
                    }
                }
                if (cstmt != null) {
                    try {
                        cstmt.close();
                    }
                    catch (SQLException ex222) {
                        this.logger.error((Object)("close statement error:" + ex222));
                    }
                }
                return bl2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.logger.info((Object)"check connection");
                    this.logger.debug((Object)this.sqlcheck);
                    this.stmt.executeQuery(this.sqlcheck);
                    this.logger.info((Object)"connection is ok");
                }
                catch (SQLException ex) {
                    this.logger.error((Object)("check connection error:" + ex.toString()));
                    this.logger.error((Object)"the connection has been broken down, set it to null to recreate");
                    this.connection = null;
                }
            }
        }
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getInfor() {
        boolean connected;
        StringBuffer buff = new StringBuffer();
        boolean bl = connected = this.connection != null;
        if (connected) {
            buff.append("Connection:" + this.connection.getClass().getName());
        }
        buff.append("\r\nUrl:" + this.cnString);
        buff.append("\r\nUsername:" + this.username);
        buff.append("\r\nPassword:" + this.password);
        buff.append("\r\nConnected:" + connected);
        return buff.toString();
    }
}

