/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapUtil {
    private static Log _log = LogFactoryUtil.getLog(MapUtil.class);

    public static void copy(Map master, Map copy) {
        copy.clear();
        MapUtil.merge(master, copy);
    }

    public static boolean getBoolean(Map map, String key) {
        return MapUtil.getBoolean(map, key, false);
    }

    public static boolean getBoolean(Map map, String key, boolean defaultValue) {
        return GetterUtil.getBoolean(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static int getInteger(Map map, String key) {
        return MapUtil.getInteger(map, key, 0);
    }

    public static int getInteger(Map map, String key, int defaultValue) {
        return GetterUtil.getInteger(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static long getLong(Map map, long key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map map, long key, long defaultValue) {
        Object value;
        Long keyObj = new Long(key);
        if (map.containsKey(keyObj) && (value = map.get(keyObj)) instanceof Long) {
            return (Long)value;
        }
        return defaultValue;
    }

    public static short getShort(Map map, String key) {
        return MapUtil.getShort(map, key, (short)0);
    }

    public static short getShort(Map map, String key, short defaultValue) {
        return GetterUtil.getShort(MapUtil.getString(map, key, String.valueOf(defaultValue)), defaultValue);
    }

    public static String getString(Map map, String key) {
        return MapUtil.getString(map, key, "");
    }

    public static String getString(Map map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof String[]) {
                String[] array = (String[])value;
                if (array.length > 0) {
                    return GetterUtil.getString(array[0], defaultValue);
                }
            } else {
                if (value instanceof String) {
                    return GetterUtil.getString((String)value, defaultValue);
                }
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static void merge(Map master, Map copy) {
        for (Map.Entry entry : master.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            copy.put(key, value);
        }
    }

    public static LinkedHashMap toLinkedHashMap(String[] params) {
        return MapUtil.toLinkedHashMap(params, ":");
    }

    public static LinkedHashMap toLinkedHashMap(String[] params, String delimiter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            String[] kvp = StringUtil.split(params[i], delimiter);
            if (kvp.length == 2) {
                map.put(kvp[0], kvp[1]);
                continue;
            }
            if (kvp.length != 3) continue;
            String type = kvp[2];
            if (type.equalsIgnoreCase("boolean") || type.equals(Boolean.class.getName())) {
                map.put(kvp[0], new Boolean(kvp[1]));
                continue;
            }
            if (type.equalsIgnoreCase("double") || type.equals(Double.class.getName())) {
                map.put(kvp[0], new Double(kvp[1]));
                continue;
            }
            if (type.equalsIgnoreCase("int") || type.equals(Integer.class.getName())) {
                map.put(kvp[0], new Integer(kvp[1]));
                continue;
            }
            if (type.equalsIgnoreCase("long") || type.equals(Long.class.getName())) {
                map.put(kvp[0], new Long(kvp[1]));
                continue;
            }
            if (type.equalsIgnoreCase("short") || type.equals(Short.class.getName())) {
                map.put(kvp[0], new Short(kvp[1]));
                continue;
            }
            if (type.equals(String.class.getName())) {
                map.put(kvp[0], kvp[1]);
                continue;
            }
            try {
                Class<?> classObj = Class.forName(type);
                Constructor<?> constructor = classObj.getConstructor(String.class);
                map.put(kvp[0], constructor.newInstance(kvp[1]));
                continue;
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return map;
    }
}

