/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;

public class PortletBeanLocatorUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletBeanLocatorUtil.class);
    private static Map<String, BeanLocator> _beanLocators = new HashMap<String, BeanLocator>();

    public static BeanLocator getBeanLocator(String servletContextName) {
        return _beanLocators.get(servletContextName);
    }

    public static Object locate(String servletContextName, String name) throws BeanLocatorException {
        BeanLocator beanLocator = PortletBeanLocatorUtil.getBeanLocator(servletContextName);
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        return beanLocator.locate(name);
    }

    public static void setBeanLocator(String servletContextName, BeanLocator beanLocator) {
        if (_log.isDebugEnabled()) {
            _log.debug("Setting BeanLocator " + beanLocator.hashCode());
        }
        _beanLocators.put(servletContextName, beanLocator);
    }
}

