/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jepexamples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TextField;
import org.nfunk.jep.JEP;

public class GraphCanvas
extends Canvas {
    private static final long serialVersionUID = -3169263228971794887L;
    private int scaleX = 1;
    private int scaleY = 1;
    private Dimension dimensions = this.getSize();
    private Image buffer;
    private boolean initializedBuffer = false;
    private boolean changedFunction = true;
    private boolean hasError = true;
    private JEP myParser;
    private TextField exprField;

    public GraphCanvas(String initialExpression, TextField exprField_in) {
        this.exprField = exprField_in;
        this.initParser(initialExpression);
    }

    private void initParser(String initialExpression) {
        this.myParser = new JEP();
        this.myParser.setImplicitMul(true);
        this.myParser.addStandardFunctions();
        this.myParser.addStandardConstants();
        this.myParser.addComplex();
        this.myParser.addVariable("x", 0.0);
        this.setExpressionString(initialExpression);
    }

    public void setExpressionString(String newString) {
        this.myParser.parseExpression(newString);
        this.hasError = this.myParser.hasError();
        if (this.hasError) {
            this.exprField.setForeground(Color.red);
        } else {
            this.exprField.setForeground(Color.black);
        }
        this.changedFunction = true;
    }

    private double getYValue(double xValue) {
        this.myParser.addVariable("x", xValue);
        return this.myParser.getValue();
    }

    private void paintWhite(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.dimensions.width, this.dimensions.height);
    }

    private void paintAxes(Graphics g) {
        g.setColor(new Color(204, 204, 204));
        g.drawLine(0, this.dimensions.height / 2, this.dimensions.width - 1, this.dimensions.height / 2);
        g.drawLine(this.dimensions.width / 2, 0, this.dimensions.width / 2, this.dimensions.height - 1);
    }

    private void paintCurve(Graphics2D g) {
        boolean firstpoint = true;
        int lastX = 0;
        int lastY = 0;
        g.setColor(Color.black);
        int xAbsolute = 0;
        while (xAbsolute <= this.dimensions.width - 1) {
            double xRelative = (xAbsolute - this.dimensions.width / 2) / this.scaleX;
            double yRelative = this.getYValue(xRelative);
            int yAbsolute = (int)(-yRelative * (double)this.scaleY + (double)(this.dimensions.height / 2));
            if (yAbsolute > this.dimensions.height) {
                yAbsolute = this.dimensions.height;
            }
            if (yAbsolute < -1) {
                yAbsolute = -1;
            }
            if (!firstpoint) {
                g.drawLine(lastX, lastY, xAbsolute, yAbsolute);
            } else {
                firstpoint = false;
            }
            lastX = xAbsolute++;
            lastY = yAbsolute;
        }
    }

    public void paint(Graphics g_in) {
        boolean changedDimensions = !this.dimensions.equals(this.getSize());
        Graphics2D g = (Graphics2D)g_in;
        if (!this.initializedBuffer || changedDimensions) {
            this.dimensions = this.getSize();
            this.buffer = this.createImage(this.dimensions.width, this.dimensions.height);
            this.initializedBuffer = true;
        }
        Graphics2D buffergc = (Graphics2D)this.buffer.getGraphics();
        buffergc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.changedFunction || changedDimensions) {
            this.paintWhite(buffergc);
            this.paintAxes(buffergc);
            if (!this.hasError) {
                this.paintCurve(buffergc);
            }
            this.changedFunction = false;
        }
        g.drawImage(this.buffer, 0, 0, null);
    }
}

