/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.cluster.agent.utils;

import com.viettel.cluster.agent.utils.ConfigHolder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConfigLoader {
    private static final String CLUSTER_NAME = "clusterName";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String NODE_NAME = "nodeName";
    private static final String INITIAL_HOSTS = "initialHosts";
    public static final String JGROUP_PROTOCOL_STACK = "protocolStack";
    private static final String SQL_MO_PATTERN = "sql";
    private static final String TIMEOUT = "timeout";
    private static final String CHECK_INTERVAL = "checkInterval";
    private static final String ENABLE_EXTRA_LOG = "extraLog";
    public static final String REDUCED_CLUSTER = "reducedWarn";
    public static final String INCREASED_CLUSTER = "increasedWarn";
    public static final String CHANGED_CLUSTER_CANNOT_CONNECT_DB = "changedClusterCannotConnectDbWarn";
    public static final String CHANGED_CLUSTER_CANNOT_CONNECT_DB_2 = "changedClusterCannotConnectDbWarn2";
    private static final String DEFAULT_PROTOCOL_STACK = "tcp.xml";
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static final long DEFAULT_CHECK_INTERVAL = 10000L;
    private static final String DEFAULT_REDUCED_CLUSTER = "Cluster changes, a few members have out from the cluster";
    private static final String DEFAULT_INCREASED_CLUSTER = "Cluster changes, a few members have joined the cluster";
    private static final String DEFAULT_CHANGED_CLUSTER_CANNOT_CONNECT_DB = "Cluster changes, cluster has one node. This node cann't connect database";
    private static final String DEFAULT_CHANGED_CLUSTER_CANNOT_CONNECT_DB_2 = "Cluster changes, cluster has many nodes. This node cann't connect database";
    public static String reducedView = "Cluster changes, a few members have out from the cluster";
    public static String increasedView = "Cluster changes, a few members have joined the cluster";
    public static String changedViewCannotConnectDb = "Cluster changes, cluster has one node. This node cann't connect database";
    public static String changedViewCannotConnectDb2 = "Cluster changes, cluster has many nodes. This node cann't connect database";
    private String configPath;
    private String id;
    private String nodeName;
    private String sqlMoPattern;
    private Long timeout;
    private Long checkInterval;
    private String clusterName;
    private String ip;
    private String port;
    private String initialHosts;
    private String protocolStack;
    private Boolean enableExtraLog;
    private final List<ConfigHolder> configList = new ArrayList<ConfigHolder>();
    private static ConfigLoader configLoader;

    public static ConfigLoader createInstance(String configPath) {
        if (configLoader == null) {
            configLoader = new ConfigLoader(configPath);
        }
        return configLoader;
    }

    public static ConfigLoader getInstance() {
        return configLoader;
    }

    public ConfigLoader(String configPath) {
        this.configPath = configPath;
        this.loadConfig();
    }

    public ConfigHolder getConfigHolder(String id) {
        for (ConfigHolder holder : this.configList) {
            if (!holder.getId().equals(id)) continue;
            return holder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        block17: {
            f = null;
            r = null;
            try {
                try {
                    f = new FileReader(this.configPath);
                    r = new BufferedReader(f);
                    while (true) {
                        if ((str = r.readLine()) == null) {
                            this.onEndFile();
                            var8_8 = null;
                            if (r == null) break block17;
                            break;
                        }
                        if (str.startsWith("#") || str.startsWith("//")) continue;
                        if (str.startsWith("[") && str.endsWith("]")) {
                            length = str.length() - 1;
                            if (length <= 1) continue;
                            this.onTag(str.substring(1, length));
                            continue;
                        }
                        if (str.indexOf("=", 0) <= 0 || str.indexOf("=", 0) >= str.length() - 1) continue;
                        i = str.indexOf(61);
                        name = str.substring(0, i).trim();
                        value = str.substring(i + 1).trim();
                        this.onValue(name, value);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger((String)"configLoader").error((Object)("Can't load config file: " + this.configPath));
                    var8_9 = null;
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger((String)"configLoader").debug((Object)("close buffer reader exception:" + ex));
                        }
                    }
                    if (f == null) return;
                    try {
                        f.close();
                        return;
                    }
                    catch (IOException ex) {
                        Logger.getLogger((String)"configLoader").debug((Object)("close file reader exception:" + ex));
                        return;
                    }
                }
            }
            catch (Throwable var7_14) {
                block20: {
                    var8_10 = null;
                    if (r != null) {
                        ** try [egrp 2[TRYBLOCK] [5 : 230->237)] { 
lbl49:
                        // 1 sources

                        r.close();
                        break block20;
lbl51:
                        // 1 sources

                        catch (IOException ex) {
                            Logger.getLogger((String)"configLoader").debug((Object)("close buffer reader exception:" + ex));
                        }
                    }
                }
                if (f == null) throw var7_14;
                ** try [egrp 3[TRYBLOCK] [6 : 271->278)] { 
lbl56:
                // 1 sources

                f.close();
                throw var7_14;
lbl58:
                // 1 sources

                catch (IOException ex) {
                    Logger.getLogger((String)"configLoader").debug((Object)("close file reader exception:" + ex));
                }
                throw var7_14;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 230->237)] { 
lbl63:
            // 1 sources

            r.close();
            break block17;
lbl65:
            // 1 sources

            catch (IOException ex) {
                Logger.getLogger((String)"configLoader").debug((Object)("close buffer reader exception:" + ex));
            }
        }
        if (f == null) return;
        ** try [egrp 3[TRYBLOCK] [6 : 271->278)] { 
lbl70:
        // 1 sources

        f.close();
        return;
lbl72:
        // 1 sources

        catch (IOException ex) {
            Logger.getLogger((String)"configLoader").debug((Object)("close file reader exception:" + ex));
        }
    }

    void reloadConfig() {
        this.loadConfig();
    }

    private void onTag(String name) {
        this.createNewConfigHolder();
        this.id = name;
    }

    private void onValue(String name, String value) {
        if (name.equals(NODE_NAME)) {
            this.nodeName = value;
        } else if (name.equals(SQL_MO_PATTERN)) {
            this.sqlMoPattern = value;
        } else if (name.equals(TIMEOUT)) {
            this.timeout = this.parseLong(value, 60000L);
        } else if (name.equals(CHECK_INTERVAL)) {
            this.checkInterval = this.parseLong(value, 10000L);
        } else if (name.equals(CLUSTER_NAME)) {
            this.clusterName = value;
        } else if (name.equals(IP)) {
            this.ip = value;
        } else if (name.equals(PORT)) {
            this.port = value;
        } else if (name.equals(INITIAL_HOSTS)) {
            this.initialHosts = value;
        } else if (name.equals(JGROUP_PROTOCOL_STACK)) {
            this.protocolStack = value == null ? DEFAULT_PROTOCOL_STACK : value;
        } else if (name.equals(ENABLE_EXTRA_LOG)) {
            this.enableExtraLog = this.parseBoolean(value, false);
        } else if (name.equals(REDUCED_CLUSTER)) {
            reducedView = value;
        } else if (name.equals(INCREASED_CLUSTER)) {
            increasedView = value;
        } else if (name.equals(CHANGED_CLUSTER_CANNOT_CONNECT_DB)) {
            changedViewCannotConnectDb = value;
        } else if (name.equals(CHANGED_CLUSTER_CANNOT_CONNECT_DB_2)) {
            changedViewCannotConnectDb2 = value;
        }
    }

    private void onEndFile() {
        this.createNewConfigHolder();
    }

    private long parseLong(String value, long defaultValue) {
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (Exception ex) {
                result = defaultValue;
                Logger.getLogger((String)"configLoader").error((Object)("Can't not parse value " + value + " to a long"));
            }
        }
        return result;
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        boolean result = defaultValue;
        if (value != null && value.equalsIgnoreCase("true")) {
            try {
                result = true;
            }
            catch (Exception ex) {
                result = defaultValue;
                Logger.getLogger((String)"configLoader").error((Object)("Can't not parse value " + value + " to a boolean"));
            }
        }
        return result;
    }

    private void createNewConfigHolder() {
        if (this.id != null && this.nodeName != null && this.sqlMoPattern != null && this.timeout != null && this.checkInterval != null && this.clusterName != null && this.ip != null && this.port != null && this.initialHosts != null && this.enableExtraLog != null) {
            ConfigHolder holder = new ConfigHolder(this.id, this.nodeName, this.sqlMoPattern, this.timeout, this.checkInterval, this.clusterName, this.ip, this.port, this.initialHosts, this.protocolStack, this.enableExtraLog);
            this.configList.add(holder);
            this.id = null;
            this.nodeName = null;
            this.sqlMoPattern = null;
            this.timeout = null;
            this.checkInterval = null;
            this.clusterName = null;
            this.ip = null;
            this.port = null;
            this.initialHosts = null;
            this.protocolStack = null;
            this.enableExtraLog = null;
        }
    }
}

