/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.framework.interceptorMDB;

import com.viettel.common.util.ArgChecker;
import com.viettel.common.util.ResourceBundleUtil;
import com.viettel.database.BO.BasicBO;
import com.viettel.database.BO.ModRule;
import com.viettel.database.config.Config;
import com.viettel.database.config.RuleSelector;
import com.viettel.security.PassTranformer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseHibernateDAOMDB {
    private static final Logger log = Logger.getLogger(BaseHibernateDAOMDB.class);
    public static HashMap<String, SessionFactory> sessionFactoryMap = new HashMap();
    public static final ThreadLocal localCurrentSessionMap = new ThreadLocal();
    private static final ThreadLocal localSessionsToRollBack = new ThreadLocal();
    private static Config config = new Config();
    private static RuleSelector ruleSelector = new RuleSelector();
    public static String configFile = "";
    private static final Owner trueOwner = new Owner(true);
    private static final Owner fakeOwner = new Owner(false);

    private static void decryptDBConfig(Configuration dbConfig, String path) {
        if ("true".equals(dbConfig.getProperty("is_information_encrypted"))) {
            String[] propertiesToDecrypt = new String[]{"hibernate.connection.url", "hibernate.connection.username", "hibernate.connection.password", "connection.url", "connection.username", "connection.password"};
            for (int i = 0; i < propertiesToDecrypt.length; ++i) {
                if (dbConfig.getProperty(propertiesToDecrypt[i]) == null) continue;
                try {
                    dbConfig.setProperty(propertiesToDecrypt[i], PassTranformer.decrypt((String)dbConfig.getProperty(propertiesToDecrypt[i])));
                    continue;
                }
                catch (Throwable ex) {
                    log.error((Object)("L\u1ed7i gi\u1ea3i m\u00e3 thu\u1ed9c t\u00ednh \"" + propertiesToDecrypt[i] + "\" c\u1ee7a file" + path), ex);
                }
            }
        } else {
            log.info((Object)("File " + path + ": is_information_encrypted is null or false"));
        }
    }

    public static Object createSessionMap() throws Exception {
        HashMap<String, Session> sessionMap = (HashMap<String, Session>)localCurrentSessionMap.get();
        if (sessionMap == null) {
            sessionMap = new HashMap<String, Session>();
            HashMap sessionsName = config.getSessions();
            for (String sessionName : sessionsName.keySet()) {
                Session s = sessionFactoryMap.get(sessionName).openSession();
                sessionMap.put(sessionName, s);
            }
            localCurrentSessionMap.set(sessionMap);
            localSessionsToRollBack.set(sessionMap);
            return trueOwner;
        }
        System.out.println("Session Found - Give a Fake identity");
        return fakeOwner;
    }

    public static HashMap<String, org.hibernate.Session> getSessionMap() throws HibernateException {
        return (HashMap)localCurrentSessionMap.get();
    }

    public static void commitSessions() throws Throwable {
        HashMap sessionMap = (HashMap)localCurrentSessionMap.get();
        HashMap<String, org.hibernate.Session> sessionsToRollBack = new HashMap<String, org.hibernate.Session>();
        boolean hasExceptionDuringCommit = false;
        if (sessionMap != null) {
            for (String sessionName : sessionMap.keySet()) {
                org.hibernate.Session session = (org.hibernate.Session)sessionMap.get(sessionName);
                if (!session.isOpen()) continue;
                Transaction t = session.getTransaction();
                if (t.isActive() && !hasExceptionDuringCommit) {
                    try {
                        t.commit();
                    }
                    catch (Throwable ex) {
                        hasExceptionDuringCommit = true;
                        sessionsToRollBack.put(sessionName, session);
                        System.out.println("Co loi xay ra khi commit transaction cua session " + sessionName);
                    }
                    continue;
                }
                if (!hasExceptionDuringCommit) continue;
                sessionsToRollBack.put(sessionName, session);
            }
        }
        if (hasExceptionDuringCommit) {
            localSessionsToRollBack.set(sessionsToRollBack);
            throw new Exception("Co loi xay ra khi commit transaction");
        }
    }

    public static void rollBackSessions() throws Exception {
        String TRANS_EX_MSG_TRANSNOTSTARTED = "Transaction not successfully started";
        HashMap sessionMap = (HashMap)localSessionsToRollBack.get();
        if (sessionMap != null) {
            for (String sessionName : sessionMap.keySet()) {
                org.hibernate.Session session = (org.hibernate.Session)sessionMap.get(sessionName);
                if (!session.isOpen()) continue;
                Transaction t = session.getTransaction();
                try {
                    t.rollback();
                }
                catch (Throwable ex) {
                    if (ex.getMessage().equals(TRANS_EX_MSG_TRANSNOTSTARTED)) {
                        System.out.println("Session " + sessionName + " khong rollback do chua started");
                        continue;
                    }
                    System.out.println("Co loi xay ra khi roll back session " + sessionName);
                }
            }
        }
    }

    public static void closeSessions(Object ownership) throws Exception {
        if (((Owner)ownership).identity) {
            HashMap sessionMaps = (HashMap)localCurrentSessionMap.get();
            if (sessionMaps != null) {
                for (org.hibernate.Session session : sessionMaps.values()) {
                    try {
                        if (!session.isOpen()) continue;
                        session.close();
                    }
                    catch (Exception ex) {}
                }
            }
            localCurrentSessionMap.set(null);
        } else {
            System.out.println("Identity is rejected. Ignoring the request");
        }
    }

    public static org.hibernate.Session getSession(String key) throws HibernateException {
        String key_tmp = key.toLowerCase();
        HashMap<String, org.hibernate.Session> sessionMaps = (HashMap<String, org.hibernate.Session>)localCurrentSessionMap.get();
        if (sessionMaps == null) {
            sessionMaps = new HashMap<String, org.hibernate.Session>();
            localCurrentSessionMap.set(sessionMaps);
        }
        org.hibernate.Session s = (org.hibernate.Session)sessionMaps.get(key_tmp);
        try {
            if (s == null || !s.isOpen()) {
                s = sessionFactoryMap.get(key_tmp).openSession();
                sessionMaps.put(key_tmp, s);
            }
        }
        catch (HibernateException ex) {
            System.out.println(" Loi Hibernate");
            ex.printStackTrace();
        }
        try {
            if (s.connection().isClosed()) {
                s = BaseHibernateDAOMDB.createSession(key_tmp, sessionMaps, s);
            }
        }
        catch (SQLException ex) {
            System.out.println("Loi ket noi");
            ex.printStackTrace();
        }
        Transaction t = s.getTransaction();
        if (t == null) {
            t = s.beginTransaction();
        } else if (!t.isActive()) {
            t.begin();
        }
        return s;
    }

    public static org.hibernate.Session getSession(int rule_type, Object rule_value) throws HibernateException {
        switch (rule_type) {
            case 1: {
                return BaseHibernateDAOMDB.getSession(ruleSelector.getValueLocation(rule_value.toString()));
            }
            case 2: {
                int tmp = (Integer)rule_value;
                if (ruleSelector.getMods().size() <= 0) break;
                ModRule modRule = (ModRule)ruleSelector.getMods().values().iterator().next();
                int key = tmp % modRule.getValue();
                return BaseHibernateDAOMDB.getSession(ruleSelector.getValueMod(String.valueOf(key)));
            }
            case 3: {
                if (!(rule_value instanceof Date)) break;
                return BaseHibernateDAOMDB.getSession(ruleSelector.getValueDateTimeRule((Date)rule_value));
            }
            default: {
                return BaseHibernateDAOMDB.getSession();
            }
        }
        return null;
    }

    public static org.hibernate.Session getSession() throws HibernateException {
        return BaseHibernateDAOMDB.getSession("default session");
    }

    public static void buildSessionFactories(HashMap<String, String> configs) {
        try {
            for (String key : configs.keySet()) {
                URL url = BaseHibernateDAOMDB.class.getResource(configs.get(key));
                SessionFactory sessionFactory = new Configuration(){}.configure(url).buildSessionFactory();
                sessionFactoryMap.put(key, sessionFactory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void buildSessionFactory(String key, String path) {
        try {
            SessionFactory sessionFactory = new Configuration().configure(path).buildSessionFactory();
            sessionFactoryMap.put(key, sessionFactory);
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void rebuildSessionFactories() {
        try {
            HashMap hashMap = config.getSessions();
            for (String key : hashMap.keySet()) {
                String path = (String)hashMap.get(key);
                SessionFactory sessionFactory = new Configuration(){}.configure(path).buildSessionFactory();
                sessionFactoryMap.put(key.toLowerCase(), sessionFactory);
            }
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }

    private static org.hibernate.Session createSession(String key_tmp, HashMap<String, org.hibernate.Session> sessionMaps, org.hibernate.Session s) throws HibernateException {
        sessionFactoryMap.put(key_tmp, new Configuration().configure((String)config.getSessions().get(key_tmp)).buildSessionFactory());
        sessionMaps.remove(key_tmp);
        s = sessionFactoryMap.get(key_tmp).openSession();
        sessionMaps.put(key_tmp, s);
        System.out.println("Finish create sessionFactory");
        return s;
    }

    public void save(BasicBO objectToSave) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        session.refresh((Object)instance);
        return instance;
    }

    public List getAll(String strClassHandle) {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession("default session");
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public static void setSessions(HashMap<String, org.hibernate.Session> sessions) {
        localCurrentSessionMap.set(sessions);
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ?";
        Query queryObject = BaseHibernateDAOMDB.getSession("default session").createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public static long getSequence(String sequenceName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = BaseHibernateDAOMDB.getSession("default session").createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public void save(BasicBO objectToSave, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle, String sessionName) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        session.refresh((Object)instance);
        return instance;
    }

    public List getAll(String strClassHandle, String sessionName) {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(sessionName);
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value, String sessionName) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ?";
        Query queryObject = BaseHibernateDAOMDB.getSession(sessionName).createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public static long getSequence(String sequenceName, String sessionName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = BaseHibernateDAOMDB.getSession(sessionName).createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public List query(String query, Object[] params) {
        ArrayList result = new ArrayList();
        Set<String> key = sessionFactoryMap.keySet();
        Iterator<String> iter = key.iterator();
        while (iter.hasNext()) {
            org.hibernate.Session s = BaseHibernateDAOMDB.getSession(iter.next());
            Query q = s.createQuery(query);
            for (int i = 0; i < params.length; ++i) {
                q.setParameter(i, params[i]);
            }
            result.addAll(q.list());
        }
        return result;
    }

    public void save(int rule_type, Object rule_value, BasicBO objectToSave) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(rule_type, rule_value);
        if (!session.getTransaction().isActive()) {
            session.beginTransaction();
        }
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(int rule_type, Object rule_value, BasicBO objectToUpdate) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(rule_type, rule_value);
        if (!session.getTransaction().isActive()) {
            session.beginTransaction();
        }
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(int rule_type, Object rule_value, BasicBO objectToSaveOrUpdate) throws Exception {
        org.hibernate.Session session = BaseHibernateDAOMDB.getSession(rule_type, rule_value);
        if (!session.getTransaction().isActive()) {
            session.beginTransaction();
        }
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    static {
        try {
            configFile = ResourceBundleUtil.getDBCConfigFileLocation();
            config.loadInstance(configFile);
            HashMap hashMap = config.getSessions();
            ruleSelector = config.getRuleSelector();
            for (String key : hashMap.keySet()) {
                String path = (String)hashMap.get(key);
                Configuration dbConfig = new Configuration(){}.configure(path);
                BaseHibernateDAOMDB.decryptDBConfig(dbConfig, path);
                SessionFactory sessionFactory = dbConfig.buildSessionFactory();
                sessionFactoryMap.put(key.toLowerCase(), sessionFactory);
            }
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
        catch (Throwable tb) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
        }
    }

    private static class Owner {
        boolean identity = false;

        public Owner(boolean identity) {
            this.identity = identity;
        }
    }
}

