/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.database.config;

import com.viettel.common.util.ArgChecker;
import com.viettel.common.util.ResourceBundleUtil;
import com.viettel.database.BO.BasicBO;
import com.viettel.security.PassTranformer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;

public class BaseHibernateDAO {
    private static final Logger log = Logger.getLogger(BaseHibernateDAO.class);
    public static final ThreadLocal<Session> threadLocal = new ThreadLocal();
    public static Configuration configuration = new Configuration();
    public static SessionFactory sessionFactory;
    public static String configFile;

    private static void decryptDBConfig(Configuration dbConfig, String path) {
        if ("true".equals(dbConfig.getProperty("is_information_encrypted"))) {
            String[] propertiesToDecrypt = new String[]{"hibernate.connection.url", "hibernate.connection.username", "hibernate.connection.password", "connection.url", "connection.username", "connection.password"};
            for (int i = 0; i < propertiesToDecrypt.length; ++i) {
                if (dbConfig.getProperty(propertiesToDecrypt[i]) == null) continue;
                try {
                    dbConfig.setProperty(propertiesToDecrypt[i], PassTranformer.decrypt((String)dbConfig.getProperty(propertiesToDecrypt[i])));
                    continue;
                }
                catch (Throwable ex) {
                    log.error((Object)("L\u1ed7i gi\u1ea3i m\u00e3 thu\u1ed9c t\u00ednh \"" + propertiesToDecrypt[i] + "\" c\u1ee7a file" + path), ex);
                }
            }
        } else {
            log.info((Object)("File " + path + ": is_information_encrypted is null or false"));
        }
    }

    public static Session getSession() throws HibernateException {
        Session session = threadLocal.get();
        return session;
    }

    public static Session openThreadSession() throws HibernateException {
        Session session = threadLocal.get();
        if (session != null) {
            if (session.isOpen()) {
                session.close();
            }
            threadLocal.remove();
        }
        if (session == null || !session.isOpen()) {
            if (sessionFactory == null) {
                BaseHibernateDAO.rebuildSessionFactory();
            }
            session = sessionFactory != null ? sessionFactory.openSession() : null;
            threadLocal.set(session);
        }
        return session;
    }

    public static void rebuildSessionFactory() {
        try {
            configuration.configure(configFile);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }

    public static void closeSession() throws HibernateException {
        Session session = threadLocal.get();
        threadLocal.set(null);
        if (session != null && session.isOpen()) {
            session.close();
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void setConfigFile(String configFile) {
        BaseHibernateDAO.configFile = configFile;
        sessionFactory = null;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public void save(BasicBO objectToSave) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        if (instance != null) {
            session.refresh((Object)instance);
        }
        return instance;
    }

    public BasicBO read(String strClassHandle, String idName, Object id) throws Exception {
        Session session = BaseHibernateDAO.getSession();
        List lstObj = session.createCriteria(strClassHandle).add((Criterion)Restrictions.eq((String)idName, (Object)id)).list();
        BasicBO obj = null;
        if (lstObj.size() > 0) {
            obj = (BasicBO)((BasicBO)lstObj.get(0)).clone();
        }
        return obj;
    }

    public List getAll(String strClassHandle) {
        Session session = BaseHibernateDAO.getSession();
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ?";
        Query queryObject = BaseHibernateDAO.getSession().createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value, String orderClause) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ? " + orderClause;
        Query queryObject = BaseHibernateDAO.getSession().createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public static long getSequence(String sequenceName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = BaseHibernateDAO.getSession().createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public static Date getSysdate() throws Exception {
        String strQuery = "SELECT sysdate as system_datetime FROM Dual";
        SQLQuery queryObject = BaseHibernateDAO.getSession().createSQLQuery(strQuery);
        queryObject.addScalar("system_datetime", (Type)Hibernate.TIMESTAMP);
        Date sysdate = (Date)queryObject.uniqueResult();
        return sysdate;
    }

    static {
        configFile = "";
        try {
            configFile = ResourceBundleUtil.getHibernateConfigFileLocation();
            configuration.configure(configFile);
            BaseHibernateDAO.decryptDBConfig(configuration, configFile);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }
}

