/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common.util;

import com.viettel.common.util.ConstConfig;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ArgChecker {
    private static Log log = LogFactory.getLog(ArgChecker.class);

    private ArgChecker() {
    }

    public static void denyNull(Object arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0, ConstConfig.NOT_NULL, ConstConfig.NOT_NULL);
    }

    public static void denyNull(Object arg0, Object arg1) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0, arg1, ConstConfig.NOT_NULL);
    }

    public static void denyNull(Object arg0, Object arg1, Object arg2) throws IllegalArgumentException {
        if (arg0 == null || arg1 == null || arg2 == null) {
            ArgChecker.deny("Null value is denied");
        }
    }

    public static void denyBlank(String arg0) throws IllegalArgumentException {
        ArgChecker.denyBlank(arg0, "A", "A");
    }

    public static void denyBlank(String arg0, String arg1) throws IllegalArgumentException {
        ArgChecker.denyBlank(arg0, arg1, "A");
    }

    public static void denyBlank(String arg0, String arg1, String arg2) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)arg0) || StringUtils.isBlank((String)arg1) || StringUtils.isBlank((String)arg2)) {
            ArgChecker.deny("Blank value is denied");
        }
    }

    public static void denyEmpty(String arg0) throws IllegalArgumentException {
        ArgChecker.denyEmpty(arg0, "A", "A");
    }

    public static void denyEmpty(String arg0, String arg1) throws IllegalArgumentException {
        ArgChecker.denyEmpty(arg0, arg1, "A");
    }

    public static void denyEmpty(String arg0, String arg1, String arg2) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)arg0) || StringUtils.isEmpty((String)arg1) || StringUtils.isEmpty((String)arg2)) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(Collection arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.size() == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(Object[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(short[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(int[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(long[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(float[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyEmpty(double[] arg0) throws IllegalArgumentException {
        ArgChecker.denyNull(arg0);
        if (arg0.length == 0) {
            ArgChecker.deny("Empty value is denied");
        }
    }

    public static void denyNotEquals(Object arg0, Object arg1) throws IllegalArgumentException {
        if (arg0 == null && arg1 == null) {
            return;
        }
        if (arg0 == null || arg1 == null || !arg1.equals(arg0)) {
            ArgChecker.deny("Different values are denied");
        }
    }

    public static void denyNotEquals(boolean arg0, boolean arg1) throws IllegalArgumentException {
        if (arg0 != arg1) {
            ArgChecker.deny("Different values are denied");
        }
    }

    public static void denyNotEquals(short arg0, short arg1) throws IllegalArgumentException {
        if (arg0 != arg1) {
            ArgChecker.deny("Different values are denied");
        }
    }

    public static void denyNotEquals(int arg0, int arg1) throws IllegalArgumentException {
        if (arg0 != arg1) {
            ArgChecker.deny("Different values are denied");
        }
    }

    public static void denyNotEquals(long arg0, long arg1) throws IllegalArgumentException {
        if (arg0 != arg1) {
            ArgChecker.deny("Different values are denied");
        }
    }

    public static void denyNotAssignableFrom(Class arg0, Class arg1) throws IllegalArgumentException {
        if (arg0 == null || arg1 == null || !arg0.isAssignableFrom(arg1)) {
            ArgChecker.deny("Not assignable from");
        }
    }

    private static void deny(String denyMsg) throws IllegalArgumentException {
        log.error((Object)("Illegal Argument : " + denyMsg));
        throw new IllegalArgumentException("Illegal Argument : " + denyMsg);
    }
}

