/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import transport.message.RouteableMessage;

public class ServiceRule
implements Serializable {
    private static Logger logger = Logger.getLogger(ServiceRule.class.getClass());
    private static final long serialVersionUID = 20091803145200L;
    protected Set<String> params = new HashSet<String>();
    String expression;
    JEP jep;

    public ServiceRule() {
    }

    public ServiceRule(String[] params, String expression) {
        this.recompile(params, expression);
    }

    public void recompile(String[] params, String expression) {
        this.setExpression(expression);
        this.setParams(params);
        try {
            Node node = this.jep.parseExpression(expression);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.jep = null;
        }
    }

    private void setExpression(String expression) {
        this.expression = expression;
    }

    private void setParams(String[] params) {
        this.clearParams();
        if (params != null && params.length > 0) {
            for (String str : params) {
                this.params.add(str);
                this.jep.addVariable(str, new Object());
            }
        }
    }

    private void clear() {
        this.clearParams();
        this.expression = "";
    }

    private void clearParams() {
        this.params.clear();
        this.jep = new JEP();
        this.jep.addStandardConstants();
        this.jep.addStandardFunctions();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Rule[param={");
        int index = 0;
        for (String param : this.params) {
            if (index > 0) {
                buff.append(",");
            }
            ++index;
            buff.append(param);
        }
        buff.append("},expression=");
        buff.append(this.expression);
        buff.append("]");
        return buff.toString();
    }

    public boolean isFilter(RouteableMessage request) {
        if (this.jep == null) {
            return false;
        }
        for (String name : this.params) {
            String value = request.get(name) != null ? request.get(name) : "";
            this.jep.setVarValue(name, (Object)value);
        }
        double val = 0.0;
        try {
            val = this.jep.getValue();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return Math.abs(1.0 - val) < 0.001;
    }

    public boolean isInstance() {
        return this.expression != null;
    }
}

