/*
 * Decompiled with CFR 0.152.
 */
package vasp.messagelogger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import utils.Config;
import utils.ConnectionException;
import utils.DataStores;
import vasp.messagelogger.DatabaseLog;
import vasp.messagelogger.FileServiceLog;
import vasp.messagelogger.RetryFailHandle;
import vasp.messagelogger.RetryHandle;
import vasp.messagelogger.ServiceLog;
import vasp.utils.VaspUtils;

public abstract class AbsServiceLog
extends DatabaseLog
implements ServiceLog {
    public static final String DEFAULT_SERVICE = "SMSWS";
    public static final String DEFAULT_COMMAND = "ERR";
    public static final String DEFAULT_DESCRIPTION = "DEFAULT";
    protected FileServiceLog fileLog;
    protected RetryHandle retryHandle;
    protected RetryFailHandle retryFailHandle;
    protected int maxRetryPerTime;
    protected int retryDuration;
    protected String configFile;
    protected long lastRetry;
    protected int maxRetryElement;
    protected int retryTimeOut = 5;
    protected String separatorSym = "@@@";
    protected String strLogTimeFmt = "MM/dd/yy HH:mm:ss'.000'";

    public AbsServiceLog(String name, String configFile) throws Exception {
        super(name);
        this.configFile = configFile;
        this.reload();
    }

    public int getMaxRetryElement() {
        return this.maxRetryElement;
    }

    @Override
    public void instance() {
        if (this.instance) {
            this.logger.warn((Object)(this.threadName + " is instanced"));
            return;
        }
        this.start();
    }

    @Override
    public void setRetryHandle(RetryHandle retryHandle) {
        this.retryHandle = retryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        InputStreamReader f = null;
        try {
            String configPath = Config.getConfigDir() + File.separator + this.configFile;
            this.logger.info((Object)("load config file from : " + configPath));
            f = new FileReader(configPath);
            Properties pro = new Properties();
            pro.load(f);
            this.maxInsertPerTime = VaspUtils.getInt(pro.getProperty("max_insert_time", "20"), 20);
            this.maxInsertTimeout = VaspUtils.getInt(pro.getProperty("insert_timeout", "20000"), 20000);
            this.maxRetryPerTime = VaspUtils.getInt(pro.getProperty("maxretry_time", "5"), 5);
            this.retryDuration = VaspUtils.getInt(pro.getProperty("retry_duration", "120000"), 120000);
            this.maxRetryElement = VaspUtils.getInt(pro.getProperty("max_retry_element", "100"), 100);
            this.retryTimeOut = VaspUtils.getInt(pro.getProperty("retry_timeout", "5"), 5);
            this.separatorSym = pro.getProperty("separator_symbol", "@@@");
            this.strLogTimeFmt = pro.getProperty("log_time_format", "MM/dd/yy HH:mm:ss'.000'");
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("fail to close stream:" + ex));
                }
            }
        }
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer(super.getInfor());
        if (this.datastore != null) {
            buff.append("\r\nmax_retry_time:" + this.maxRetryPerTime);
            buff.append("\r\nretry_duration:" + this.retryDuration);
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxSessionId(String table) {
        this.logger.info((Object)("get max sessionid from " + table));
        int max_sessionid = 0;
        ResultSet rs = null;
        try {
            rs = DataStores.doQuery((String)("select max(to_number(sessionid)) from " + table));
            if (rs.next()) {
                max_sessionid = rs.getInt(1);
            }
            rs.close();
        }
        catch (ConnectionException e) {
            this.logger.error((Object)"get max sessionid error");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"get max sessionid error");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("fail to close stream:" + ex));
            }
        }
        return max_sessionid;
    }

    public int getMaxRetryPerTime() {
        return this.maxRetryPerTime;
    }

    public void setMaxRetryPerTime(int maxRetryTime) {
        this.maxRetryPerTime = maxRetryTime;
    }

    public int getRetryDuration() {
        return this.retryDuration;
    }

    public void setRetryFailHandle(RetryFailHandle handle) {
        this.retryFailHandle = handle;
    }

    public void setRetryDuration(int retryDuration) {
        this.retryDuration = retryDuration;
    }

    @Override
    protected MBeanAttributeInfo[] buildAttributes() {
        MBeanAttributeInfo[] mInfors = super.buildAttributes();
        MBeanAttributeInfo[] mNewInfors = new MBeanAttributeInfo[mInfors.length + 2];
        System.arraycopy(mInfors, 0, mNewInfors, 0, mInfors.length);
        mNewInfors[mInfors.length] = new MBeanAttributeInfo("MaxRetryRecord", "java.lang.Integer", "max record from database for one retry", true, true, false);
        mNewInfors[mInfors.length + 1] = new MBeanAttributeInfo("RetryDuration", "java.lang.Integer", "Interval time betwen two retry(mili second)", true, true, false);
        return mNewInfors;
    }

    @Override
    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attribute_name.equals("MaxRetryRecord")) {
            return this.getMaxRetryPerTime();
        }
        if (attribute_name.equals("RetryDuration")) {
            return this.getRetryDuration();
        }
        return super.getAttribute(attribute_name);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (name.equals("MaxRetryRecord")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setMaxRetryPerTime((Integer)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals("RetryDuration")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setRetryDuration((Integer)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            super.setAttribute(attribute);
        }
    }
}

