/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.TcpMessage;

public class BoundResponse
extends TcpMessage {
    protected int retn;
    protected String serviceId;

    public BoundResponse(String serviceId, int retn) {
        super(2, 15);
        this.type = (byte)2;
        this.serviceId = serviceId;
        this.retn = retn;
    }

    public BoundResponse(byte[] b) throws Exception {
        super(2, 15);
        AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
        this.retn = buf.popInt();
        this.serviceId = buf.popCString(10);
        this.type = buf.popByte();
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        try {
            buf.appendByte(this.type);
            buf.appendCString(this.serviceId, 10);
            buf.appendInt(this.retn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buf.array();
    }

    public int getRetn() {
        return this.retn;
    }

    public void setRetn(int error) {
        this.retn = error;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public String debugString() {
        return "BoundResponse (ServiceId=" + this.serviceId + ", Return=" + this.retn + ")";
    }
}

