/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp;

import transport.message.Response;
import transport.tcp.message.BoundRequest;
import transport.tcp.message.BoundResponse;
import transport.tcp.message.DeliverReport;
import transport.tcp.message.HeartBeat;
import transport.tcp.message.ServiceForward;
import transport.tcp.message.ServiceRequest;
import transport.tcp.message.ServiceResponse;
import transport.tcp.message.SubmitResponse;
import transport.tcp.message.TcpMessage;
import transport.tcp.message.UnBoundRequest;

public class TcpMessageFactory {
    private static int nMsgId;

    public static TcpMessage createMessage(byte[] b) throws Exception {
        TcpMessage msg = null;
        byte nType = b[0];
        switch (nType) {
            case 0: {
                msg = new HeartBeat();
                break;
            }
            case 1: {
                msg = new BoundRequest(b);
                break;
            }
            case 2: {
                msg = new BoundResponse(b);
                break;
            }
            case 4: {
                msg = new ServiceRequest(b);
                break;
            }
            case 5: {
                msg = new ServiceResponse(b);
                break;
            }
            case 6: {
                msg = new ServiceForward(b);
                break;
            }
            case 8: {
                msg = new SubmitResponse(b);
                break;
            }
            case 7: {
                msg = new DeliverReport(b);
            }
        }
        return msg;
    }

    public static BoundRequest createRegister(String serviceId, String username, String password) {
        BoundRequest request = new BoundRequest(serviceId, username, password);
        return request;
    }

    public static UnBoundRequest createUnRegister(String serviceId) {
        UnBoundRequest request = new UnBoundRequest(serviceId, null);
        return request;
    }

    public static ServiceRequest createRequest(String gateway, String serviceId, String sender, String receiver, String content) {
        ServiceRequest request = new ServiceRequest(null, gateway, "-1", serviceId, sender, receiver, content);
        return request;
    }

    public static Response createResponse(ServiceRequest request, String data, int retn) {
        return TcpMessageFactory.createResponse(request, data.getBytes(), retn, 0);
    }

    public static Response createResponse(ServiceRequest request, byte[] data, int retn) {
        return TcpMessageFactory.createResponse(request, data, retn, 1);
    }

    public static Response createResponse(ServiceRequest request, byte[] data, int retn, int dataType) {
        TcpMessageFactory.increaseMsg();
        String msgId = "" + nMsgId;
        String supplyId = request.getProvider();
        String gatewayId = request.getGateway();
        String sessionId = request.getSessionId();
        String serviceId = request.getServiceId();
        String sender = request.getReceiver();
        String receiver = request.getSender();
        int contentLength = data == null ? -1 : data.length;
        return new ServiceResponse(supplyId, gatewayId, msgId, sessionId, serviceId, sender, receiver, dataType, contentLength, data, retn);
    }

    public static Response createResponse(String supplyId, String gatewayId, String serviceId, String sender, String receiver, String content) {
        if (content == null) {
            content = "";
        }
        TcpMessageFactory.increaseMsg();
        String msgId = "" + nMsgId;
        String sessionId = "-1";
        int contentType = 0;
        int contentLength = content.length();
        int retn = 2;
        return new ServiceResponse(supplyId, gatewayId, msgId, sessionId, serviceId, sender, receiver, contentType, contentLength, content.getBytes(), retn);
    }

    private static void increaseMsg() {
        if (++nMsgId == Integer.MAX_VALUE) {
            nMsgId = 0;
        }
    }
}

