/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalDestinationEventListener
implements DestinationEventListener {
    private MessageListener _listener;
    private Map<String, String> _ignoredDestinations;

    public GlobalDestinationEventListener(MessageListener listener, List<String> ignoredDestinations) {
        this._listener = listener;
        this._ignoredDestinations = new HashMap<String, String>();
        for (String destination : ignoredDestinations) {
            this._ignoredDestinations.put(destination, destination);
        }
    }

    @Override
    public void destinationAdded(Destination destination) {
        if (!this._ignoredDestinations.containsKey(destination.getName())) {
            destination.register(this._listener);
        }
    }

    @Override
    public void destinationRemoved(Destination destination) {
        if (!this._ignoredDestinations.containsKey(destination.getName())) {
            destination.unregister(this._listener);
        }
    }
}

