/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.config;

import com.viettel.mmserver.config.Formatter;
import com.viettel.mmserver.config.Param;
import com.viettel.mmserver.config.TextParamException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextParam
extends Param {
    public static final int TEXTAREA_COLUMN = 30;
    public static final int TEXTAREA_ROW = 4;
    private Formatter formatter = null;
    private TextType type = TextType.TEXT_FIELD;
    private String value = "";

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
        this.ensureValidateData();
    }

    public boolean isDifferent(Param p) {
        if (p instanceof TextParam) {
            TextParam lp = (TextParam)p;
            return !lp.getValue().equals(this.value) || !lp.type.equals((Object)this.type);
        }
        return true;
    }

    public synchronized JComponent getComponent() {
        if (this.type.equals((Object)TextType.TEXT_FIELD)) {
            return new JTextField(this.value);
        }
        return new JTextArea(this.value, 4, 30);
    }

    public Param getCopy() {
        TextParam copy = new TextParam(this.getName(), new String(this.value), this.isReadOnly(), this.type, this.formatter);
        return copy;
    }

    public TextParam() {
    }

    public TextParam(String value) {
        this.value = value;
    }

    public TextParam(String value, Formatter formater) {
        this(value);
        this.formatter = formater;
        this.ensureValidateData();
    }

    public TextParam(String value, TextType type) {
        this.value = value;
        this.type = type;
    }

    public TextParam(String value, TextType type, Formatter formatter) {
        this(value, type);
        this.formatter = formatter;
        this.ensureValidateData();
    }

    public TextParam(String name, String value) {
        super(name);
        this.value = value;
    }

    public TextParam(String name, String value, Formatter formatter) {
        this(name, value);
        this.formatter = formatter;
        this.ensureValidateData();
    }

    public TextParam(String name, String value, boolean readOnly) {
        super(name, readOnly);
        this.value = value;
    }

    public TextParam(String name, String value, boolean readOnly, Formatter formater) {
        this(name, value, readOnly);
        this.formatter = formater;
        this.ensureValidateData();
    }

    public TextParam(String name, String value, TextType type) {
        super(name);
        this.value = value;
        this.type = type;
    }

    public TextParam(String name, String value, TextType type, Formatter formatter) {
        this(name, value, type);
        this.formatter = formatter;
        this.ensureValidateData();
    }

    public TextParam(String name, String value, boolean readOnly, TextType type) {
        this(name, value, readOnly);
        this.type = type;
    }

    public TextParam(String name, String value, boolean readOnly, TextType type, Formatter formatter) {
        this(name, value, readOnly, type);
        this.formatter = formatter;
        this.ensureValidateData();
    }

    public TextType getType() {
        return this.type;
    }

    public void setType(TextType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.ensureValidateData();
    }

    public String toString() {
        return this.value;
    }

    private void ensureValidateData() {
        if (this.formatter != null && this.value != null && !this.formatter.verify(this.value)) {
            throw new TextParamException("value is in wrong format");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextType {
        TEXT_FIELD,
        TEXT_AREA;

    }
}

