/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class OverlappingUnicastMergeTest
extends ChannelTestBase {
    private JChannel a;
    private JChannel b;
    private JChannel c;
    private MyReceiver ra;
    private MyReceiver rb;
    private MyReceiver rc;

    @BeforeMethod
    void start() throws Exception {
        this.ra = new MyReceiver("A");
        this.rb = new MyReceiver("B");
        this.rc = new MyReceiver("C");
        this.a = this.createChannel(true, 3);
        this.a.setReceiver(this.ra);
        this.b = this.createChannel(this.a);
        this.b.setReceiver(this.rb);
        this.c = this.createChannel(this.a);
        this.c.setReceiver(this.rc);
        OverlappingUnicastMergeTest.modifyConfigs(this.a, this.b, this.c);
        this.a.connect("OverlappingUnicastMergeTest");
        this.b.connect("OverlappingUnicastMergeTest");
        this.c.connect("OverlappingUnicastMergeTest");
        View view = this.c.getView();
        OverlappingUnicastMergeTest.assertEquals("view is " + view, 3, view.size());
    }

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.c, this.b, this.a);
    }

    public void testWithAllViewsInSync() throws Exception {
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    public void testWithViewBC() throws Exception {
        System.out.println("A's view: " + this.a.getView());
        View new_view = Util.createView(this.b.getLocalAddress(), 10L, this.b.getLocalAddress(), this.c.getLocalAddress());
        OverlappingUnicastMergeTest.injectView(new_view, this.b, this.c);
        OverlappingUnicastMergeTest.assertEquals("A's view is " + this.a.getView(), 3, this.a.getView().size());
        OverlappingUnicastMergeTest.assertEquals("B's view is " + this.b.getView(), 2, this.b.getView().size());
        OverlappingUnicastMergeTest.assertEquals("C's view is " + this.c.getView(), 2, this.c.getView().size());
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    public void testWithViewA() throws Exception {
        View new_view = Util.createView(this.a.getLocalAddress(), 10L, this.a.getLocalAddress());
        OverlappingUnicastMergeTest.injectView(new_view, this.a, this.b, this.c);
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    public void testWithViewC() throws Exception {
        View new_view = Util.createView(this.c.getLocalAddress(), 10L, this.c.getLocalAddress());
        OverlappingUnicastMergeTest.injectView(new_view, this.a, this.b, this.c);
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    public void testWithEveryoneHavingASingletonView() throws Exception {
        OverlappingUnicastMergeTest.injectView(Util.createView(this.a.getLocalAddress(), 10L, this.a.getLocalAddress()), this.a);
        OverlappingUnicastMergeTest.injectView(Util.createView(this.b.getLocalAddress(), 10L, this.b.getLocalAddress()), this.b);
        OverlappingUnicastMergeTest.injectView(Util.createView(this.c.getLocalAddress(), 10L, this.c.getLocalAddress()), this.c);
        this.sendAndCheckMessages(5, this.a, this.b, this.c);
    }

    private static void injectView(View view, JChannel ... channels) {
        for (JChannel ch : channels) {
            ch.down(new Event(6, view));
            ch.up(new Event(6, view));
        }
        for (JChannel ch : channels) {
            MyReceiver receiver = (MyReceiver)ch.getReceiver();
            System.out.println("[" + receiver.name + "] view=" + ch.getView());
        }
    }

    private void sendAndCheckMessages(int num_msgs, JChannel ... channels) throws Exception {
        this.ra.clear();
        this.rb.clear();
        this.rc.clear();
        HashSet<Address> mbrs = new HashSet<Address>(channels.length);
        for (JChannel ch : channels) {
            mbrs.add(ch.getLocalAddress());
        }
        for (JChannel ch : channels) {
            Address addr = ch.getLocalAddress();
            for (Address dest : mbrs) {
                for (int i = 1; i <= num_msgs; ++i) {
                    ch.send(dest, null, (Serializable)((Object)("unicast msg #" + i + " from " + addr)));
                }
            }
        }
        int total_msgs = num_msgs * channels.length;
        MyReceiver[] receivers = new MyReceiver[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            receivers[i] = (MyReceiver)channels[i].getReceiver();
        }
        OverlappingUnicastMergeTest.checkReceivedMessages(total_msgs, receivers);
    }

    private static void checkReceivedMessages(int num_ucasts, MyReceiver ... receivers) {
        for (int i = 0; i < 20; ++i) {
            boolean all_received = true;
            for (MyReceiver receiver : receivers) {
                List<Message> ucasts = receiver.getUnicasts();
                int ucasts_received = ucasts.size();
                if (num_ucasts == ucasts_received) continue;
                all_received = false;
                break;
            }
            if (all_received) break;
            Util.sleep(500L);
        }
        for (MyReceiver receiver : receivers) {
            List<Message> ucasts = receiver.getUnicasts();
            int ucasts_received = ucasts.size();
            System.out.println("receiver " + receiver + ": ucasts=" + ucasts_received);
            OverlappingUnicastMergeTest.assertEquals("ucasts for " + receiver + ": " + OverlappingUnicastMergeTest.print(ucasts), num_ucasts, ucasts_received);
        }
    }

    public static String print(List<Message> list) {
        StringBuilder sb = new StringBuilder();
        for (Message msg : list) {
            sb.append(msg.getSrc()).append(": ").append(msg.getObject()).append(" ");
        }
        return sb.toString();
    }

    private static void modifyConfigs(JChannel ... channels) throws Exception {
        for (JChannel ch : channels) {
            ProtocolStack stack = ch.getProtocolStack();
            stack.removeProtocol("MERGE2");
            stack.removeProtocol("VERIFY_SUSPECT");
            stack.removeProtocol("FC");
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        final String name;
        final List<Message> ucasts = new ArrayList<Message>(20);

        public MyReceiver(String name) {
            this.name = name;
        }

        @Override
        public void receive(Message msg) {
            boolean mcast;
            Address dest = msg.getDest();
            boolean bl = mcast = dest == null;
            if (!mcast) {
                this.ucasts.add(msg);
            }
        }

        @Override
        public void viewAccepted(View new_view) {
        }

        public List<Message> getUnicasts() {
            return this.ucasts;
        }

        public void clear() {
            this.ucasts.clear();
        }

        public String toString() {
            return this.name;
        }
    }
}

