/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.tcttaglib.newtag;

import com.viettel.tcttaglib.newtag.VScrollTableTHtmlTableWriterTemplate;
import com.viettel.tcttaglib.newtag.VTScrollTableSmartListHelper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.TableWriterAdapter;
import org.displaytag.tags.CaptionTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.DefaultHref;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.ParamEncoder;

public class VTScrollTableHtmlTableWriter
extends TableWriterAdapter {
    private static Log log = LogFactory.getLog(VTScrollTableHtmlTableWriter.class);
    private TableModel tableModel;
    private TableProperties properties;
    private JspWriter out;
    private ParamEncoder paramEncoder;
    private Href baseHref;
    private boolean export;
    private CaptionTag captionTag;
    private PaginatedList paginatedList;
    private VTScrollTableSmartListHelper listHelper;
    private int pagesize;
    private String requestURI;
    private String targets;
    private HtmlAttributeMap attributeMap;
    private String uid;
    int lowestEndedGroup;
    int lowestStartedGroup;
    String callback;
    String waitTime;
    String columDataType;
    LinkedHashMap htmlAttributesArr = new LinkedHashMap();

    public VTScrollTableHtmlTableWriter(TableModel tableModel, TableProperties tableProperties, Href baseHref, boolean export, JspWriter out, CaptionTag captionTag, PaginatedList paginatedList, VTScrollTableSmartListHelper listHelper, int pagesize, HtmlAttributeMap attributeMap, String uid, String requestURI, String targets, String columDataType, String waitTime, String callback) {
        this.tableModel = tableModel;
        this.properties = tableProperties;
        this.baseHref = baseHref;
        this.export = export;
        this.out = out;
        this.captionTag = captionTag;
        this.paginatedList = paginatedList;
        this.listHelper = listHelper;
        this.pagesize = pagesize;
        this.attributeMap = attributeMap;
        this.uid = uid;
        this.requestURI = requestURI;
        this.targets = targets;
        this.columDataType = columDataType;
        this.waitTime = waitTime;
        this.callback = callback;
    }

    protected void writeTopBanner(TableModel model) {
        this.writeSearchResultAndNavigation();
    }

    protected void writeTableOpener(TableModel model, String type) {
        this.write(this.getOpenTag(type));
    }

    protected void writeCaption(TableModel model) {
        this.write(this.captionTag.getOpenTag() + model.getCaption() + this.captionTag.getCloseTag());
    }

    protected void writePreBodyFooter(TableModel model) {
        this.write("\n<tfoot>");
        this.write(model.getFooter());
        this.write("</tfoot>");
    }

    protected void writeTableBodyOpener(TableModel model) {
        this.write("\n<tbody>");
    }

    protected void writeTableBodyCloser(TableModel model) {
        this.write("</tbody>");
    }

    protected void writeTableCloser(TableModel model) {
        this.write("</");
        this.write("table");
        this.write(">");
    }

    protected void writeBottomBanner(TableModel model) {
        this.writeNavigationAndExportLinks();
    }

    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    protected void writeDecoratedRowStart(TableModel model) {
        this.write(model.getTableDecorator().startRow());
    }

    protected void writeRowOpener(Row row, int trCounter) {
        this.write(row.getOpenTag());
    }

    protected void writeColumnOpener(Column column) throws ObjectLookupException, DecoratorException {
        this.write(column.getOpenTag());
    }

    protected void writeColumnCloser(Column column) {
        this.write(column.getCloseTag());
    }

    protected void writeRowWithNoColumns(String rowValue) {
        this.write("\n<td>");
        this.write(rowValue);
        this.write("</td>");
    }

    protected void writeRowCloser(Row row) {
        this.write(row.getCloseTag());
    }

    protected void writeDecoratedRowFinish(TableModel model) {
        this.write(model.getTableDecorator().finishRow());
    }

    protected void writeEmptyListMessage(String emptyListMessage) {
        this.write(emptyListMessage);
    }

    protected void writeColumnValue(Object value, Column column) {
        this.write(value);
    }

    protected void writeEmptyListRowMessage(String message) {
        this.write(message);
    }

    protected void writeTableHeader(TableModel model) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.tableModel.getId() + "] getTableHeader called"));
        }
        this.write("\n<thead>");
        this.write("\n<tr>");
        if (this.tableModel.isEmpty()) {
            this.write("\n<th>");
            this.write("</th>");
        }
        Iterator iterator = this.tableModel.getHeaderCellList().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            if (headerCell.getSortable()) {
                String cssSortable = this.properties.getCssSortable();
                headerCell.addHeaderClass(cssSortable);
            }
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass(this.properties.getCssSorted());
                headerCell.addHeaderClass(this.properties.getCssOrder(this.tableModel.isSortOrderAscending()));
            }
            this.htmlAttributesArr.put(i, "" + headerCell.getHtmlAttributes());
            ++i;
            String html = headerCell.getHeaderOpenTag().replaceFirst(">", " " + headerCell.getHtmlAttributes() + ">");
            this.write(html);
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                Anchor anchor = new Anchor(this.getSortingHref(headerCell), header);
                header = anchor.toString();
                String attTagerts = " targets =\"";
                String attDojotype = " dojotype =\"struts:BindAnchor\" executescripts=\"true\" parsecontent=\"true\" ";
                String sortUsingNameParamater = " sortUsingNameParamater=\"" + this.paramEncoder.encodeParameterName("s") + "\"";
                String orderParameter = " orderParameter=\"" + this.paramEncoder.encodeParameterName("n") + "\"";
                String sortParamater = " sortParamater=\"" + this.paramEncoder.encodeParameterName("o") + "\"";
                if (this.targets == null) {
                    attTagerts = "";
                    attDojotype = "";
                }
                header = "<a " + sortUsingNameParamater + orderParameter + sortParamater + attTagerts + this.targets + "\" " + attDojotype + header.substring(3, header.length());
            }
            this.write(header);
            this.write(headerCell.getHeaderCloseTag());
        }
        this.write("</tr>");
        this.write("</thead>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.tableModel.getId() + "] getTableHeader end"));
        }
    }

    private Href getSortingHref(HeaderCell headerCell) {
        Href href = (Href)this.baseHref.clone();
        if (this.paginatedList == null) {
            if (!this.tableModel.isLocalSort() && headerCell.getSortName() != null) {
                href.addParameter(this.encodeParameter("s"), (Object)headerCell.getSortName());
                href.addParameter(this.encodeParameter("n"), (Object)"1");
            } else {
                href.addParameter(this.encodeParameter("s"), headerCell.getColumnNumber());
            }
            boolean nowOrderAscending = true;
            if (headerCell.getDefaultSortOrder() != null) {
                boolean sortAscending = SortOrderEnum.ASCENDING.equals((Object)headerCell.getDefaultSortOrder());
                nowOrderAscending = headerCell.isAlreadySorted() ? !this.tableModel.isSortOrderAscending() : sortAscending;
            } else {
                nowOrderAscending = !headerCell.isAlreadySorted() || !this.tableModel.isSortOrderAscending();
            }
            int sortOrderParam = nowOrderAscending ? SortOrderEnum.ASCENDING.getCode() : SortOrderEnum.DESCENDING.getCode();
            href.addParameter(this.encodeParameter("o"), sortOrderParam);
            if (this.tableModel.isSortFullTable() || !this.tableModel.isLocalSort()) {
                href.addParameter(this.encodeParameter("s"), 1);
            }
        } else {
            String sortProperty;
            if (this.properties.getPaginationSkipPageNumberInSort()) {
                href.removeParameter(this.properties.getPaginationPageNumberParam());
            }
            if ((sortProperty = headerCell.getSortProperty()) == null) {
                sortProperty = headerCell.getBeanPropertyName();
            }
            href.addParameter(this.properties.getPaginationSortParam(), (Object)sortProperty);
            String dirParam = headerCell.isAlreadySorted() ? (this.tableModel.isSortOrderAscending() ? this.properties.getPaginationDescValue() : this.properties.getPaginationAscValue()) : this.properties.getPaginationAscValue();
            href.addParameter(this.properties.getPaginationSortDirectionParam(), (Object)dirParam);
            if (this.paginatedList.getSearchId() != null) {
                href.addParameter(this.properties.getPaginationSearchIdParam(), (Object)this.paginatedList.getSearchId());
            }
        }
        return href;
    }

    private String encodeParameter(String parameterName) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(this.tableModel.getId());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }

    public void writeNavigationAndExportLinks() {
        if (this.properties.getAddPagingBannerBottom()) {
            this.writeSearchResultAndNavigation();
        }
        if (this.export && this.tableModel.getRowListPage().size() != 0) {
            this.writeExportLinks();
        }
    }

    public void writeSearchResultAndNavigation() {
        if (this.paginatedList == null && this.pagesize != 0 && this.listHelper != null || this.paginatedList != null) {
            String pageParameter;
            DefaultHref navigationHref = new DefaultHref("");
            this.write(this.listHelper.getSearchResultsSummary());
            if (this.paginatedList == null) {
                pageParameter = this.encodeParameter("p");
            } else {
                pageParameter = this.properties.getPaginationPageNumberParam();
                if (this.paginatedList.getSearchId() != null && !navigationHref.getParameterMap().containsKey(this.properties.getPaginationSearchIdParam())) {
                    navigationHref.addParameter(this.properties.getPaginationSearchIdParam(), (Object)this.paginatedList.getSearchId());
                }
            }
            this.write(this.listHelper.getPageNavigationBar((Href)navigationHref, pageParameter, this.requestURI, this.targets));
        }
    }

    private void writeExportLinks() {
        Href exportHref = (Href)this.baseHref.clone();
        StringBuffer buffer = new StringBuffer(200);
        Iterator iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = (MediaTypeEnum)iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e"), currentExportType.getCode());
            exportHref.addParameter("6578706f7274", (Object)"1");
            Anchor anchor = new Anchor(exportHref, this.properties.getExportLabel(currentExportType));
            buffer.append(anchor.toString());
        }
        Object[] exportOptions = new String[]{buffer.toString()};
        this.write(MessageFormat.format(this.properties.getExportBanner(), exportOptions));
    }

    public String getOpenTag(String type) {
        if (this.uid != null && this.attributeMap.get((Object)"id") == null) {
            Map localAttributeMap = (Map)this.attributeMap.clone();
            String suffix = type;
            localAttributeMap.put("id", this.uid + suffix);
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n<").append("table");
            buffer.append(localAttributeMap);
            buffer.append(">");
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<").append("table");
        buffer.append(this.attributeMap);
        buffer.append(">");
        return buffer.toString();
    }

    public void write(String string) {
        if (string != null) {
            try {
                this.out.write(string);
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
    }

    public void writeTable(TableModel model, String id, Long height) throws JspException {
        this.writeScrollTable(model, id, height);
    }

    public void writeScrollTable(TableModel model, String id, Long height) throws JspException {
        try {
            String html;
            boolean noItems;
            TableProperties properties = model.getProperties();
            boolean bl = noItems = model.getRowListPage().size() == 0;
            if (noItems && !properties.getEmptyListShowTable()) {
                this.writeEmptyListMessage(properties.getEmptyListMessage());
                return;
            }
            if (properties.getAddPagingBannerTop()) {
                this.writeTopBanner(model);
            }
            if (height != null) {
                html = "<div class=\"dataTable-div-headerTable-wrapper\">";
                html = html + "<div class=\"dataTable-div-headerTable\">";
                this.write(html);
            }
            this.writeTableOpener(model, "header");
            if (model.getCaption() != null) {
                this.writeCaption(model);
            }
            if (model.getProperties().getShowHeader()) {
                this.writeTableHeader(model);
            }
            this.writeTableCloser(model);
            String prefixColumnFieldName = this.uid + "_JDataTableMod_f";
            String JFilterInitCode = "";
            if (this.columDataType != null) {
                String[] columnDataTypeArr = this.columDataType.split(",");
                html = "<thead><tr>";
                for (int i = 0; i < columnDataTypeArr.length; ++i) {
                    html = html + "<th " + this.htmlAttributesArr.get(i) + " >";
                    if (!"-".equalsIgnoreCase(columnDataTypeArr[i])) {
                        JFilterInitCode = JFilterInitCode + (i == 0 ? "" : ",");
                        JFilterInitCode = JFilterInitCode + "['" + prefixColumnFieldName + i + "', '" + columnDataTypeArr[i] + "', " + i + "]";
                        html = html + "<input type='text' class='txt' id='" + prefixColumnFieldName + i + "' name='" + prefixColumnFieldName + i + "' />";
                    } else {
                        html = html + "&nbsp;";
                    }
                    html = html + "</th>";
                }
                html = html + "</tr></thead>";
                JFilterInitCode = "jTblStore." + this.uid + "_JDataTableMod.bindForm( " + JFilterInitCode + " );";
                JFilterInitCode = JFilterInitCode + this.uid + "_JDataTableMod_search = function() { jTblStore." + this.uid + "_JDataTableMod.search(); };";
                JFilterInitCode = JFilterInitCode + "jTblStore." + this.uid + "_JDataTableMod.filter( '" + this.uid + "_JDataTableMod_search' );";
                if (this.waitTime != null) {
                    JFilterInitCode = JFilterInitCode + "jTblStore." + this.uid + "_JDataTableMod.setWaitTime( " + this.waitTime + " );";
                }
                if (this.callback != null) {
                    JFilterInitCode = JFilterInitCode + "jTblStore." + this.uid + "_JDataTableMod.setDblClickCallback( '" + this.callback + "' );";
                }
                this.writeTableOpener(model, "search");
                this.write(html);
                this.writeTableCloser(model);
            }
            if (height != null) {
                html = "</div>";
                html = html + "</div>";
                this.write(html);
            }
            if (height != null) {
                html = "<div hidefocus=\"true\" class=\"dataTable-div-bodyTable\" style=\"height:" + height + ";\">";
                this.write(html);
            }
            this.writeTableOpener(model, "");
            if (model.getFooter() != null) {
                this.writePreBodyFooter(model);
            }
            this.writeTableBodyOpener(model);
            this.writeTableBody(model);
            this.writeTableBodyCloser(model);
            if (model.getFooter() != null) {
                this.writePostBodyFooter(model);
            }
            this.writeTableCloser(model);
            if (height != null) {
                html = "</div>";
                this.write(html);
            }
            if (model.getTableDecorator() != null) {
                this.writeDecoratedTableFinish(model);
            }
            this.writeBottomBanner(model);
            html = "<script>jTblStore." + this.uid + "_JDataTableMod = new JDataTableMod();" + "jTblStore." + this.uid + "_JDataTableMod.setTable( '" + this.uid + "' );" + JFilterInitCode + "jTblStore." + this.uid + "_JDataTableMod.assignWholeTable();" + "</script>";
            this.write(html);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    private void writeTableBody(TableModel model) throws Exception {
        RowIterator rowIterator = model.getRowIterator(false);
        TableDecorator tableDecorator = model.getTableDecorator();
        Row previousRow = null;
        Row currentRow = null;
        Row nextRow = null;
        HashMap previousRowValues = new HashMap(10);
        HashMap currentRowValues = new HashMap(10);
        HashMap<Integer, VScrollTableTHtmlTableWriterTemplate.CellStruct> nextRowValues = new HashMap<Integer, VScrollTableTHtmlTableWriterTemplate.CellStruct>(10);
        int trCounter = 0;
        while (nextRow != null || rowIterator.hasNext()) {
            VScrollTableTHtmlTableWriterTemplate.CellStruct struct;
            Column column;
            ColumnIterator columnIterator;
            if (currentRow == null) {
                currentRow = rowIterator.next();
            } else {
                previousRow = currentRow;
                currentRow = nextRow;
            }
            if (previousRow != null) {
                previousRowValues.putAll(currentRowValues);
            }
            if (!nextRowValues.isEmpty()) {
                currentRowValues.putAll(nextRowValues);
            } else {
                columnIterator = currentRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" creating ColumnIterator on " + model.getHeaderCellList()));
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    struct = new VScrollTableTHtmlTableWriterTemplate.CellStruct(column, column.getChoppedAndLinkedValue());
                    currentRowValues.put(new Integer(column.getHeaderCell().getColumnNumber()), struct);
                }
            }
            nextRowValues.clear();
            Row row = nextRow = rowIterator.hasNext() ? rowIterator.next() : null;
            if (nextRow != null) {
                columnIterator = nextRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" creating ColumnIterator on " + model.getHeaderCellList()));
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    struct = new VScrollTableTHtmlTableWriterTemplate.CellStruct(column, column.getChoppedAndLinkedValue());
                    nextRowValues.put(new Integer(column.getHeaderCell().getColumnNumber()), struct);
                }
            }
            if (tableDecorator != null) {
                tableDecorator.initRow(currentRow.getObject(), currentRow.getRowNumber(), currentRow.getRowNumber() + rowIterator.getPageOffset());
            }
            Iterator headerCellsIter = model.getHeaderCellList().iterator();
            ArrayList<VScrollTableTHtmlTableWriterTemplate.CellStruct> structsForRow = new ArrayList<VScrollTableTHtmlTableWriterTemplate.CellStruct>(model.getHeaderCellList().size());
            this.lowestEndedGroup = 42000;
            this.lowestStartedGroup = 42000;
            while (headerCellsIter.hasNext()) {
                HeaderCell header = (HeaderCell)headerCellsIter.next();
                VScrollTableTHtmlTableWriterTemplate.CellStruct struct2 = (VScrollTableTHtmlTableWriterTemplate.CellStruct)currentRowValues.get(new Integer(header.getColumnNumber()));
                struct2.decoratedValue = struct2.bodyValue;
                if (header.getGroup() != -1) {
                    VScrollTableTHtmlTableWriterTemplate.CellStruct prior = (VScrollTableTHtmlTableWriterTemplate.CellStruct)previousRowValues.get(new Integer(header.getColumnNumber()));
                    VScrollTableTHtmlTableWriterTemplate.CellStruct next = (VScrollTableTHtmlTableWriterTemplate.CellStruct)nextRowValues.get(new Integer(header.getColumnNumber()));
                    String priorBodyValue = prior != null ? prior.bodyValue : null;
                    String nextBodyValue = next != null ? next.bodyValue : null;
                    short groupingValue = this.groupColumns(struct2.bodyValue, priorBodyValue, nextBodyValue, header.getGroup());
                    if (tableDecorator != null) {
                        switch (groupingValue) {
                            case -2: {
                                tableDecorator.startOfGroup(struct2.bodyValue, header.getGroup());
                                break;
                            }
                            case 5: {
                                tableDecorator.endOfGroup(struct2.bodyValue, header.getGroup());
                                break;
                            }
                            case 3: {
                                tableDecorator.startOfGroup(struct2.bodyValue, header.getGroup());
                                tableDecorator.endOfGroup(struct2.bodyValue, header.getGroup());
                                break;
                            }
                        }
                    }
                    if (tableDecorator != null) {
                        struct2.decoratedValue = tableDecorator.displayGroupedValue(struct2.bodyValue, groupingValue, header.getColumnNumber());
                    } else if (groupingValue == 5 || groupingValue == 0) {
                        struct2.decoratedValue = "";
                    }
                }
                structsForRow.add(struct2);
            }
            if (tableDecorator != null) {
                this.writeDecoratedRowStart(model);
            }
            this.writeRowOpener(currentRow, trCounter++);
            for (VScrollTableTHtmlTableWriterTemplate.CellStruct struct2 : structsForRow) {
                this.writeColumnOpener(struct2.column);
                this.writeColumnValue(struct2.decoratedValue, struct2.column);
                this.writeColumnCloser(struct2.column);
            }
            if (model.isEmpty()) {
                this.writeRowWithNoColumns(currentRow.getObject().toString());
            }
            this.writeRowCloser(currentRow);
            if (model.getTableDecorator() == null) continue;
            this.writeDecoratedRowFinish(model);
        }
        if (model.getRowListPage().size() == 0) {
            this.writeEmptyListRowMessage(MessageFormat.format(model.getProperties().getEmptyListRowMessage(), new Integer(model.getNumberOfColumns())));
        }
    }

    public void write(Object string) {
        if (string != null) {
            try {
                this.out.write(string.toString());
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
    }
}

