/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.database.DAO;

import com.opensymphony.xwork2.ActionSupport;
import com.viettel.common.util.ArgChecker;
import com.viettel.database.BO.BasicBO;
import com.viettel.framework.interceptor.BaseHibernateDAO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;

public class BaseDAOAction
extends ActionSupport {
    private Session session;
    private Exception exception;

    public Object getTabSession(String attributeName) {
        HttpServletRequest req = this.getRequest();
        String pageId = req.getParameter("pageId");
        if (pageId == null) {
            pageId = "";
        }
        return req.getSession().getAttribute(attributeName + pageId);
    }

    public void setTabSession(String attributeName, Object value) {
        HttpServletRequest req = this.getRequest();
        String pageId = req.getParameter("pageId");
        if (pageId == null) {
            pageId = "";
        }
        req.getSession().setAttribute(attributeName + pageId, value);
    }

    public void removeTabSession(String attributeName) {
        HttpServletRequest req = this.getRequest();
        String pageId = req.getParameter("pageId");
        if (pageId == null) {
            pageId = "";
        }
        req.getSession().removeAttribute(attributeName + pageId);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Session getSession() {
        return BaseHibernateDAO.getSession();
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void save(BasicBO objectToSave) throws Exception {
        Session session = this.getSession();
        ArgChecker.denyNull(objectToSave);
        session.save((Object)objectToSave);
    }

    public void update(BasicBO objectToUpdate) throws Exception {
        Session session = this.getSession();
        ArgChecker.denyNull(objectToUpdate);
        session.update((Object)objectToUpdate);
    }

    public void saveOrUpdate(BasicBO objectToSaveOrUpdate) throws Exception {
        Session session = this.getSession();
        ArgChecker.denyNull(objectToSaveOrUpdate);
        session.saveOrUpdate((Object)objectToSaveOrUpdate);
    }

    public void delete(BasicBO objectToDelete) throws Exception {
        Session session = this.getSession();
        ArgChecker.denyNull(objectToDelete);
        session.delete((Object)objectToDelete);
    }

    public void refresh(BasicBO objectToRefresh) throws Exception {
        Session session = this.getSession();
        session.refresh((Object)objectToRefresh);
    }

    public BasicBO get(Object id, String strClassHandle) throws Exception {
        Session session = this.getSession();
        BasicBO instance = (BasicBO)session.get(strClassHandle, (Serializable)id);
        if (instance != null) {
            session.refresh((Object)instance);
        }
        return instance;
    }

    public BasicBO read(String strClassHandle, String idName, Object id) throws Exception {
        Session session = this.getSession();
        List lstObj = session.createCriteria(strClassHandle).add((Criterion)Restrictions.eq((String)idName, (Object)id)).list();
        BasicBO obj = null;
        if (lstObj.size() > 0) {
            obj = (BasicBO)((BasicBO)lstObj.get(0)).clone();
        }
        return obj;
    }

    public List getAll(String strClassHandle) {
        Session session = this.getSession();
        String queryString = "from " + strClassHandle;
        Query queryObject = session.createQuery(queryString);
        return queryObject.list();
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ?";
        Query queryObject = this.getSession().createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public List findByProperty(String strClassHandle, String propertyName, Object value, String orderClause) {
        List lstReturn = new ArrayList();
        String queryString = "from " + strClassHandle + " as model where model." + propertyName + "= ? " + orderClause;
        Query queryObject = this.getSession().createQuery(queryString);
        queryObject.setParameter(0, value);
        lstReturn = queryObject.list();
        return lstReturn;
    }

    public long getSequence(String sequenceName) throws Exception {
        String strQuery = "SELECT " + sequenceName + " .NextVal FROM Dual";
        SQLQuery queryObject = this.getSession().createSQLQuery(strQuery);
        BigDecimal bigDecimal = (BigDecimal)queryObject.uniqueResult();
        return bigDecimal.longValue();
    }

    public Date getSysdate() throws Exception {
        String strQuery = "SELECT sysdate as system_datetime FROM Dual";
        SQLQuery queryObject = this.getSession().createSQLQuery(strQuery);
        queryObject.addScalar("system_datetime", (Type)Hibernate.TIMESTAMP);
        Date sysdate = (Date)queryObject.uniqueResult();
        return sysdate;
    }

    public HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }
}

