/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import utils.Config;
import utils.Hex;
import vasp.Command;

public class VaspUtils {
    private static String rconfig = "resources.conf";
    private static Properties pro = new Properties();
    public static final char STARTDELIM = '%';
    public static final char ENDDELIM = '%';
    private static final char[][] signChars = new char[][]{{'a', '\u00e0', '\u00e1', '\u1ea3', '\u00e3', '\u1ea1', '\u0103', '\u1eb1', '\u1eaf', '\u1eb3', '\u1eb5', '\u1eb7', '\u00e2', '\u1eaf', '\u1ea7', '\u1ea5', '\u1ea9', '\u1eab', '\u1ead'}, {'o', '\u00f2', '\u00f3', '\u1ecf', '\u00f5', '\u1ecd', '\u00f4', '\u1ed3', '\u1ed1', '\u1ed5', '\u1ed7', '\u1ed9', '\u01a1', '\u1edd', '\u1edb', '\u1edf', '\u1ee1', '\u1ee3'}, {'e', '\u00e8', '\u00e9', '\u1ebb', '\u1ebd', '\u1eb9', '\u00ea', '\u1ec1', '\u1ebf', '\u1ec3', '\u1ec3', '\u1ec7'}, {'u', '\u00f9', '\u00fa', '\u1ee7', '\u0169', '\u1ee5', '\u01b0', '\u1eeb', '\u1ee9', '\u1eed', '\u1eef', '\u1ef1'}, {'i', '\u00ec', '\u00ed', '\u1ec9', '\u0129', '\u1ecb'}, {'y', '\u1ef3', '\u00fd', '\u1ef7', '\u1ef9', '\u1ef5'}, {'d', '\u0111'}};
    private static Logger logger = Logger.getLogger(VaspUtils.class);

    public static final String toUnSign(String orgStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < orgStr.length(); ++i) {
            char c = VaspUtils.toUnsign(orgStr.charAt(i));
            if (!VaspUtils.isAscii(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static final String toSmsText(String orgStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int max = (orgStr = orgStr.trim()).length() > 320 ? 320 : orgStr.length();
        for (int i = 0; i < max; ++i) {
            char c = VaspUtils.toUnsign(orgStr.charAt(i));
            if (!VaspUtils.isSmsChar(c) && c != ' ') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static final String toAsciiText(String orgStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int max = (orgStr = orgStr.trim()).length() > 320 ? 320 : orgStr.length();
        for (int i = 0; i < max; ++i) {
            char c = orgStr.charAt(i);
            if (!VaspUtils.isAscii(c) && c != ' ') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static final boolean isSmsChar(char c) {
        return c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static final boolean isAscii(char c) {
        return c > '\u001f' && c < '\u007f';
    }

    public static final char toUnsign(char c) {
        char[][] arr$ = signChars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char[] signChar;
            for (char aSignChar : signChar = arr$[i$]) {
                if (aSignChar != c) continue;
                return signChar[0];
            }
        }
        return c;
    }

    public static boolean isAllNumber(String mNumber) {
        if (mNumber == null || mNumber.length() == 0) {
            return false;
        }
        for (int i = 0; i < mNumber.length(); ++i) {
            char c = mNumber.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isValidMobile(String mobile) {
        return VaspUtils.isAllNumber(mobile) && mobile.length() > 6;
    }

    public static final String formatMobile(String msisdn) {
        if (msisdn == null) {
            return "";
        }
        if (msisdn.length() == 10 && msisdn.startsWith("09")) {
            msisdn = "84" + msisdn.substring(1);
        }
        return msisdn;
    }

    public static final String getFullTimeDesp() {
        return VaspUtils.getFullTimeDesp(new Date());
    }

    public static final String getFullTimeDesp(Date date) {
        SimpleDateFormat d = new SimpleDateFormat("HH:mm:ss dd-MM-yyyy");
        return d.format(date);
    }

    public static final String getFullDate() {
        SimpleDateFormat d = new SimpleDateFormat("dd-MM-yyyy");
        return d.format(new Date());
    }

    public static final String getFullTime() {
        SimpleDateFormat d = new SimpleDateFormat("HH:mm:ss");
        return d.format(new Date());
    }

    public static final String getTimeDesp() {
        SimpleDateFormat d = new SimpleDateFormat("dd_MM_yyyy");
        return d.format(new Date());
    }

    public static final String formatDate(Date date, String formated) {
        SimpleDateFormat d = new SimpleDateFormat(formated);
        return d.format(date);
    }

    private static final boolean isSeparator(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static final Command getCommand(String content, int max) {
        int i;
        if (content == null || content.length() == 0) {
            return new Command();
        }
        content = content.trim();
        int length = content.length();
        for (i = 0; i < length && !VaspUtils.isSeparator(content.charAt(i)); ++i) {
        }
        String indentify = content.substring(0, i);
        Vector<String> v = new Vector<String>();
        if (i < length) {
            int index = 0;
            while (i < length) {
                int end;
                while (i < length && VaspUtils.isSeparator(content.charAt(i))) {
                    ++i;
                }
                int start = i;
                if (index == max) {
                    i = length;
                } else {
                    while (i < length && !VaspUtils.isSeparator(content.charAt(i))) {
                        ++i;
                    }
                }
                if ((end = i) <= start) continue;
                v.addElement(content.substring(start, end));
                ++index;
            }
        }
        String[] args = null;
        if (v.size() > 0) {
            args = new String[v.size()];
            for (i = 0; i < v.size(); ++i) {
                args[i] = (String)v.elementAt(i);
            }
        }
        if (indentify.length() > 30) {
            indentify = indentify.substring(0, 10);
        }
        return new Command(indentify, args);
    }

    public static final Command getCommand(String content, char separator, int max) {
        int i;
        if (content == null || content.length() == 0) {
            return new Command();
        }
        content = content.trim();
        int length = content.length();
        for (i = 0; i < length && content.charAt(i) != separator; ++i) {
        }
        String indentify = content.substring(0, i);
        Vector<String> v = new Vector<String>();
        if (i < length) {
            int index = 0;
            while (i < length) {
                int end;
                while (i < length && content.charAt(i) == separator) {
                    ++i;
                }
                int start = i;
                if (index == max) {
                    i = length;
                } else {
                    while (i < length && content.charAt(i) != separator) {
                        ++i;
                    }
                }
                if ((end = i) <= start) continue;
                v.addElement(content.substring(start, end));
                ++index;
            }
        }
        String[] args = null;
        if (v.size() > 0) {
            args = new String[v.size()];
            for (i = 0; i < v.size(); ++i) {
                args[i] = (String)v.elementAt(i);
            }
        }
        if (indentify.length() > 30) {
            indentify = indentify.substring(0, 10);
        }
        return new Command(indentify, args);
    }

    public static final long parseLong(String value, int radix) {
        long l;
        try {
            l = Long.parseLong(value, radix);
        }
        catch (NumberFormatException ex) {
            l = -1L;
            logger.error((Object)("format exception:" + ex));
            ex.printStackTrace();
        }
        return l;
    }

    public static final int getInt(String key, int defaultValue) {
        int i;
        try {
            i = Integer.parseInt(key);
        }
        catch (NumberFormatException ex) {
            logger.error((Object)("format exception:" + ex));
            i = defaultValue;
        }
        return i;
    }

    public static final String[] split(String listKey, String token) {
        if (listKey == null || listKey.length() == 0) {
            return new String[0];
        }
        StringTokenizer tk = new StringTokenizer(listKey, token);
        String[] values = new String[tk.countTokens()];
        int idx = 0;
        while (tk.hasMoreTokens()) {
            try {
                values[idx] = tk.nextToken();
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            ++idx;
        }
        return values;
    }

    public static final String replace(String str, String[] replace, char startdelim, char enddelim) {
        if (replace == null) {
            return str;
        }
        int i = 0;
        StringBuffer buf = new StringBuffer(str);
        for (String aReplace : replace) {
            i = VaspUtils.replace(buf, aReplace, i, startdelim, enddelim);
        }
        return buf.toString().trim();
    }

    public static final String replace(String str, String replace, char startdelim, char enddelim) {
        boolean isStated = false;
        int startIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == startdelim && !isStated) {
                startIndex = i;
                isStated = true;
                continue;
            }
            if (c != enddelim || !isStated) continue;
            return str.substring(0, startIndex) + replace + str.substring(i + 1);
        }
        return str.trim();
    }

    public static final int replace(StringBuffer buf, String replace, int start, char startdelim, char enddelim) {
        boolean isStated = false;
        int startIndex = 0;
        for (int i = start; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == startdelim && !isStated) {
                startIndex = i;
                isStated = true;
                continue;
            }
            if (c != enddelim || !isStated) continue;
            buf.replace(startIndex, i + 1, replace);
            return startIndex + replace.length();
        }
        return buf.length();
    }

    public static final String replace(String str, String[] replace) {
        char startdelim = '%';
        char enddelim = '%';
        if (replace == null) {
            return str;
        }
        String repString = str;
        for (String aReplace : replace) {
            repString = VaspUtils.replace(repString, aReplace, startdelim, enddelim);
        }
        return repString;
    }

    public static final String replace(String str, String replace) {
        char startdelim = '%';
        char enddelim = '%';
        boolean isStated = false;
        int startIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == startdelim && !isStated) {
                startIndex = i;
                isStated = true;
                continue;
            }
            if (c != enddelim || !isStated) continue;
            return str.substring(0, startIndex) + replace + str.substring(i + 1);
        }
        return str.trim();
    }

    public static final boolean matcher(String value, String pattern) {
        if (pattern == null || value == null) {
            return false;
        }
        Pattern p = Pattern.compile(pattern, 34);
        Matcher m = p.matcher(value);
        return m.matches();
    }

    public static final boolean wildcmp(String value, String pattern) {
        return VaspUtils.matcher(value, pattern);
    }

    public static final String n2aEncode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] buf = str.toCharArray();
        int len = buf.length;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (buf[i] > '\u007f') {
                out.append('\\');
                out.append('u');
                String hex = Integer.toHexString(buf[i]);
                int length = 4 - hex.length();
                for (int j = 0; j < length; ++j) {
                    out.append('0');
                }
                out.append(hex);
                continue;
            }
            out.append(buf[i]);
        }
        return out.toString();
    }

    public static final String n2aDecode(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] buf = str.toCharArray();
        int len = buf.length;
        int index = 0;
        StringBuffer out = new StringBuffer();
        while (index < len) {
            if (index < len - 6 && buf[index] == '\\' && buf[index + 1] == 'u') {
                try {
                    String s = new String(buf, index + 2, 4);
                    char c = (char)Integer.parseInt(s, 16);
                    out.append(c);
                    index += 6;
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("format exception:" + e));
                    out.append(buf[index]);
                    out.append(buf[index + 1]);
                    index += 2;
                }
                continue;
            }
            out.append(buf[index]);
            ++index;
        }
        return out.toString();
    }

    public static final String formatString(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\r') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig() {
        pro.clear();
        String configFile = Config.getConfigDir() + File.separator + rconfig;
        FileInputStream in = null;
        try {
            logger.info((Object)("load resouce variable from file: " + configFile));
            in = new FileInputStream(configFile);
            pro.load(in);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                logger.error((Object)("fail to close stream:" + ex));
            }
        }
    }

    public static final String validMobileNumber(String mb) {
        if (mb == null) {
            return "";
        }
        if (mb.length() == 10 && mb.startsWith("0")) {
            mb = "84" + mb.substring(1);
        }
        return mb;
    }

    public static final String getResourceString(int errorCode) {
        String s = Integer.toString(errorCode);
        StringBuffer suffix = new StringBuffer();
        for (int i = s.length(); i < 5; ++i) {
            suffix.append('0');
        }
        String key = suffix + s;
        return pro.getProperty(key, "");
    }

    public static final String getResourceString(String key) {
        return pro.getProperty(key, "");
    }

    public static final String byteArraytoHexString(byte[] bytes) {
        return Hex.encode((byte[])bytes);
    }

    public static final byte[] hexStringToByteArray(String str) {
        return Hex.decode((String)str);
    }

    public static final int getMts(byte[] content) {
        int mts = 0;
        int s = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] == 9) {
                ++mts;
                s = ++i;
                continue;
            }
            if (i - s <= 140) continue;
            ++mts;
            s = i;
        }
        return ++mts;
    }

    public static final String add(String[] listStr) {
        return VaspUtils.add(listStr, ",");
    }

    public static final String add(String[] listStr, String separator) {
        StringBuffer buff = new StringBuffer();
        if (listStr != null && listStr.length > 0) {
            for (int i = 0; i < listStr.length; ++i) {
                if (i > 0) {
                    buff.append(separator);
                }
                buff.append(listStr[i]);
            }
        }
        return buff.toString();
    }

    public static final String join(String[] listStr, String separator) {
        return VaspUtils.add(listStr, separator);
    }

    public static final long increase(long l, long value) {
        if ((l += value) == Long.MAX_VALUE) {
            l = 0L;
        }
        return l;
    }

    public static final int increase(int i, int value) {
        try {
            if ((i += value) == Integer.MAX_VALUE) {
                i = 0;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            i = 0;
        }
        return i;
    }

    public static final String max(String str, int length) {
        if (str == null) {
            return "";
        }
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }
}

