/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import desktopapplication1.EncryptDecryptUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import utils.Config;
import utils.DataStores;
import vasp.utils.ConfigLoader;

public class DatabaseLoader
extends ConfigLoader {
    public DatabaseLoader() {
        super("Database");
    }

    public void loadConfig() {
        block11: {
            String configFile = Config.getConfigDir() + File.separator + "database.conf";
            try {
                String s;
                FileReader f = new FileReader(configFile);
                BufferedReader r = new BufferedReader(f);
                String driver = null;
                String connection_file = null;
                String sqlcheck = "select 1 from dual";
                boolean pooling = false;
                while ((s = DatabaseLoader.read(r)) != null) {
                    if (s.startsWith("#")) continue;
                    if (s.startsWith("driver")) {
                        driver = DatabaseLoader.getValue(s, "=");
                        continue;
                    }
                    if (s.startsWith("connection_file")) {
                        connection_file = DatabaseLoader.getValue(s, "=");
                        continue;
                    }
                    if (s.startsWith("sqlcheck")) {
                        sqlcheck = DatabaseLoader.getValue(s, "=");
                        continue;
                    }
                    if (!s.startsWith("pooling")) continue;
                    pooling = "true".equals(DatabaseLoader.getValue(s, "="));
                }
                if (driver == null || connection_file == null) break block11;
                String connection = null;
                String username = null;
                String password = null;
                try {
                    String connectionInfo = EncryptDecryptUtils.decryptFile(connection_file);
                    String[] propertyVal = connectionInfo.split("\\n");
                    if (propertyVal.length == 3) {
                        for (int i = 0; i < propertyVal.length; ++i) {
                            propertyVal[i] = propertyVal[i].replaceAll(".*=", "");
                        }
                        connection = propertyVal[0];
                        username = propertyVal[1];
                        password = propertyVal[2];
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.logger.error((Object)ex);
                }
                if (connection != null && username != null && password != null) {
                    DataStores.init((String)driver, (String)connection, username, password, (String)sqlcheck, (boolean)pooling);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

