/*
 * Decompiled with CFR 0.152.
 */
package transport.rmi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import transport.rmi.RmiListener;
import utils.Config;
import utils.Queue;
import vasp.utils.ConfigLoader;

public class RmiLoader {
    public static RmiListener loadConfig(RmiListener rmilistener, Queue rx) {
        Logger logger = Logger.getLogger(RmiLoader.class);
        String url = null;
        String username = null;
        String password = null;
        try {
            String configFile = Config.getConfigDir() + File.separator + "rmi-listener.conf";
            logger.info((Object)("load rmi config from: " + configFile));
            FileReader f = new FileReader(configFile);
            BufferedReader r = new BufferedReader(f);
            String s = ConfigLoader.read(r);
            while (s != null) {
                int i;
                if (s.startsWith("url") && (i = s.indexOf(61)) > 0 && i < s.length() - 1) {
                    url = s.substring(i + 1).trim();
                }
                if (s.startsWith("username") && (i = s.indexOf(61)) > 0 && i < s.length() - 1) {
                    username = s.substring(i + 1).trim();
                }
                if (s.startsWith("password") && (i = s.indexOf(61)) > 0 && i < s.length() - 1) {
                    password = s.substring(i + 1).trim();
                }
                s = ConfigLoader.read(r);
            }
            r.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (url != null && username != null && password != null) {
            if (rmilistener != null) {
                rmilistener.reload(url, username, password);
            } else {
                logger.info((Object)("instance rmi listener url=" + url + ", username=" + username + ", password=" + password));
                return new RmiListener(url, username, password, rx);
            }
        }
        return rmilistener;
    }
}

