/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ServiceFilter;
import filter.SpamModule;
import java.util.Vector;
import org.apache.log4j.Logger;
import utils.DataStores;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;
import vasp.utils.CommandUtils;

public abstract class AntiSpam
implements ServiceFilter,
Commandable {
    protected Vector<SpamModule> spamModules = new Vector();
    protected Logger logger = Logger.getLogger((String)"antispam");

    public AntiSpam() {
        this.reload();
    }

    protected abstract String[] loadSpamModule();

    @Override
    public void reload() {
        if (!DataStores.isInstanced()) {
            this.logger.warn((Object)"the DataStores hasn't been instanced, can't load or reload this AntiSpam");
            return;
        }
        for (SpamModule spamModule : this.spamModules) {
            spamModule.destroy();
        }
        this.spamModules.clear();
        String[] spamModuleNames = this.loadSpamModule();
        if (spamModuleNames != null && spamModuleNames.length > 0) {
            for (String spamModule : spamModuleNames) {
                SpamModule sModule = new SpamModule(spamModule);
                this.spamModules.add(sModule);
            }
        }
    }

    @Override
    public void destroy() {
        for (SpamModule spamModule : this.spamModules) {
            spamModule.destroy();
        }
    }

    protected SpamModule getSpamModule(String name) {
        for (SpamModule spamModule : this.spamModules) {
            if (!spamModule.getName().equals(name)) continue;
            return spamModule;
        }
        return null;
    }

    @Override
    public CommandResponse exec(CommandRequest cmdRequest) {
        String id = cmdRequest.getIndentify();
        String[] args = cmdRequest.getArgs();
        if ("reload".equals(id) && args.length >= 3) {
            if (this.spamModules.size() > 0) {
                for (int i = 0; i < this.spamModules.size(); ++i) {
                    SpamModule module = this.spamModules.get(i);
                    if (!args[2].equals(module.getName())) continue;
                    module.reload();
                    return cmdRequest.createResponse("the antispam module " + args[2] + " has been reloaded");
                }
            }
            return cmdRequest.createResponse("invalid spam module name");
        }
        if ("show".equals(id) && args.length >= 3) {
            if (this.spamModules.size() > 0) {
                for (int i = 0; i < this.spamModules.size(); ++i) {
                    SpamModule module = this.spamModules.get(i);
                    if (!args[2].equals(module.getName())) continue;
                    if (args.length == 3) {
                        return cmdRequest.createResponse(module.getInfor());
                    }
                    if (!"request".equals(args[3]) || args.length != 5) continue;
                    module.showRequests(args[4]);
                    return cmdRequest.createResponse("show request in log file");
                }
            }
            return cmdRequest.createResponse("invalid spam module name");
        }
        if ("clear".equals(id) && args.length >= 3) {
            if (this.spamModules.size() > 0) {
                for (int i = 0; i < this.spamModules.size(); ++i) {
                    SpamModule module = this.spamModules.get(i);
                    if (!args[2].equals(module.getName()) || !"request".equals(args[3]) || args.length != 5) continue;
                    module.clearRequests(args[4]);
                    return cmdRequest.createResponse("all request of " + args[4] + " in spam module was cleared");
                }
            }
            return cmdRequest.createResponse("invalid spam module name");
        }
        return cmdRequest.createResponse("invalid command");
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append(CommandUtils.format("id", 1, 12));
        buff.append(CommandUtils.format("name", 1, 25));
        int id = 1;
        if (this.spamModules.size() > 0) {
            for (int i = 0; i < this.spamModules.size(); ++i) {
                buff.append("\r\n");
                String idx = String.valueOf(id++);
                buff.append(CommandUtils.format(idx, 1, 12));
                buff.append(CommandUtils.format(this.spamModules.get(i).getName(), 1, 25));
            }
        }
        return buff.toString();
    }

    @Override
    public String getName() {
        return "antispam";
    }
}

