/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemJarLoader {
    static Logger logger = Logger.getLogger((String)"Loader");
    static ArrayList<String> urls = new ArrayList();

    private SystemJarLoader() {
    }

    public static String getMainClassName(URL url) throws IOException {
        URL u = new URL("jar", "", url.toString() + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        Attributes attr = uc.getMainAttributes();
        return attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
    }

    public static void addFile(String s) throws IOException, PrivilegedActionException {
        File f = new File(s);
        SystemJarLoader.addFile(f);
    }

    public static void addFile(File f) throws IOException, PrivilegedActionException {
        if (f.exists() && (f.getPath().endsWith(".jar") || f.getPath().endsWith(".zip"))) {
            SystemJarLoader.addURL(f.toURI().toURL());
        }
    }

    public static void addURL(final URL u) throws IOException, PrivilegedActionException {
        for (String s : urls) {
            if (!s.equals(u.toString())) continue;
            return;
        }
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                logger.info((Object)("add URL: " + u.toString()));
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                try {
                    Class<URL> parameters = URL.class;
                    Method method = sysclass.getDeclaredMethod("addURL", parameters);
                    method.setAccessible(true);
                    method.invoke((Object)sysloader, u);
                    return sysloader;
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage());
                    throw new IOException("Error, could not add URL to system classloader");
                }
            }
        });
    }

    public static void addDir(String jarDir) throws MalformedURLException, IOException, PrivilegedActionException {
        File dir = new File(jarDir);
        File[] f = dir.listFiles();
        if (f != null && f.length != 0) {
            for (File ff : f) {
                if (ff.isDirectory()) {
                    SystemJarLoader.addDir(ff.getPath());
                    continue;
                }
                if (!ff.getName().endsWith(".jar")) continue;
                SystemJarLoader.addFile(ff);
            }
        }
    }

    public static URL toUrl(String file) throws MalformedURLException {
        return new File(file).toURI().toURL();
    }

    public static <T> T loadClass(String c) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.info((Object)("load class  :" + c));
        return (T)Class.forName(c).newInstance();
    }

    public static <T> T loadClass(String jar, String c) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, PrivilegedActionException {
        SystemJarLoader.addFile(jar);
        return SystemJarLoader.loadClass(c);
    }
}

