/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.shell;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.shell.Shell;
import net.wimpi.telnetd.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShellManager {
    private static Log log = LogFactory.getLog(ShellManager.class);
    private static ShellManager c_Self;
    private HashMap m_Shells;

    private ShellManager() {
    }

    private ShellManager(HashMap shells) {
        c_Self = this;
        this.m_Shells = new HashMap(shells.size());
        this.setupShells(shells);
    }

    public Shell getShell(String key) {
        Shell myShell = null;
        try {
            if (!this.m_Shells.containsKey(key)) {
                return null;
            }
            Class shclass = (Class)this.m_Shells.get(key);
            Method factory = shclass.getMethod("createShell", null);
            log.debug((Object)("[Factory Method] " + factory.toString()));
            myShell = (Shell)factory.invoke((Object)shclass, null);
        }
        catch (Exception e) {
            log.error((Object)"getShell()", (Throwable)e);
        }
        return myShell;
    }

    private void setupShells(HashMap shells) {
        String sh = "";
        String shclassstr = "";
        HashMap shellclasses = new HashMap(shells.size());
        Iterator iter = shells.keySet().iterator();
        while (iter.hasNext()) {
            try {
                sh = (String)iter.next();
                shclassstr = (String)shells.get(sh);
                log.debug((Object)("Preparing Shell [" + sh + "] " + shclassstr));
                if (shellclasses.containsKey(shclassstr)) {
                    this.m_Shells.put(sh, shellclasses.get(shclassstr));
                    log.debug((Object)("Class [" + shclassstr + "] already loaded, using cached class object."));
                    continue;
                }
                Class<?> shclass = Class.forName(shclassstr);
                this.m_Shells.put(sh, shclass);
                shellclasses.put(shclassstr, shclass);
                log.debug((Object)("Class [" + shclassstr + "] loaded and class object cached."));
            }
            catch (Exception e) {
                log.error((Object)"setupShells()", (Throwable)e);
            }
        }
    }

    public static ShellManager createShellManager(Properties settings) throws BootException {
        try {
            log.debug((Object)"createShellManager()");
            HashMap<String, String> shells = new HashMap<String, String>();
            String sh = settings.getProperty("shells");
            if (sh != null) {
                String[] customshs = StringUtil.split(sh, ",");
                for (int z = 0; z < customshs.length; ++z) {
                    sh = settings.getProperty("shell." + customshs[z] + ".class");
                    if (sh == null) {
                        log.debug((Object)("Shell entry named " + customshs[z] + " not found."));
                        throw new BootException("Shell " + customshs[z] + " declared but not defined.");
                    }
                    shells.put(customshs[z], sh);
                }
            }
            ShellManager shm = new ShellManager(shells);
            return shm;
        }
        catch (Exception ex) {
            log.error((Object)"createManager()", (Throwable)ex);
            throw new BootException("Creating ShellManager Instance failed:\n" + ex.getMessage());
        }
    }

    public static ShellManager getReference() {
        return c_Self;
    }
}

