/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Locale;
import net.wimpi.telnetd.net.ConnectionManager;

public class ConnectionData {
    private ConnectionManager m_CM;
    private Socket m_Socket;
    private InetAddress m_IP;
    private HashMap m_Environment;
    private String m_HostName;
    private String m_HostAddress;
    private int m_Port;
    private Locale m_Locale;
    private long m_LastActivity;
    private boolean m_Warned;
    private String m_NegotiatedTerminalType;
    private int[] m_TerminalGeometry;
    private boolean m_TerminalGeometryChanged = true;
    private String m_LoginShell;
    private boolean m_LineMode = false;
    private String m_EchoMode = "server";

    public ConnectionData(Socket sock, ConnectionManager cm) {
        this.m_Socket = sock;
        this.m_CM = cm;
        this.m_IP = sock.getInetAddress();
        this.setHostName();
        this.setHostAddress();
        this.setLocale();
        this.m_Port = sock.getPort();
        this.m_TerminalGeometry = new int[2];
        this.m_TerminalGeometry[0] = 80;
        this.m_TerminalGeometry[1] = 25;
        this.m_NegotiatedTerminalType = "default";
        this.m_Environment = new HashMap(20);
        this.activity();
    }

    public ConnectionManager getManager() {
        return this.m_CM;
    }

    public Socket getSocket() {
        return this.m_Socket;
    }

    public int getPort() {
        return this.m_Port;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public String getHostAddress() {
        return this.m_HostAddress;
    }

    public InetAddress getInetAddress() {
        return this.m_IP;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public long getLastActivity() {
        return this.m_LastActivity;
    }

    public void activity() {
        this.m_Warned = false;
        this.m_LastActivity = System.currentTimeMillis();
    }

    public void setWarned(boolean bool) {
        this.m_Warned = bool;
        if (!bool) {
            this.m_LastActivity = System.currentTimeMillis();
        }
    }

    public boolean isWarned() {
        return this.m_Warned;
    }

    public void setTerminalGeometry(int width, int height) {
        this.m_TerminalGeometry[0] = width;
        this.m_TerminalGeometry[1] = height;
        this.m_TerminalGeometryChanged = true;
    }

    public int[] getTerminalGeometry() {
        if (this.m_TerminalGeometryChanged) {
            this.m_TerminalGeometryChanged = false;
        }
        return this.m_TerminalGeometry;
    }

    public int getTerminalColumns() {
        return this.m_TerminalGeometry[0];
    }

    public int getTerminalRows() {
        return this.m_TerminalGeometry[1];
    }

    public boolean isTerminalGeometryChanged() {
        return this.m_TerminalGeometryChanged;
    }

    public void setNegotiatedTerminalType(String termtype) {
        this.m_NegotiatedTerminalType = termtype;
    }

    public String getNegotiatedTerminalType() {
        return this.m_NegotiatedTerminalType;
    }

    public HashMap getEnvironment() {
        return this.m_Environment;
    }

    public void setLoginShell(String s) {
        this.m_LoginShell = s;
    }

    public String getLoginShell() {
        return this.m_LoginShell;
    }

    public boolean isLineMode() {
        return this.m_LineMode;
    }

    public void setLineMode(boolean b) {
        this.m_LineMode = b;
    }

    private void setHostName() {
        this.m_HostName = this.m_IP.getHostName();
    }

    private void setHostAddress() {
        this.m_HostAddress = this.m_IP.getHostAddress();
    }

    private void setLocale() {
        String country = this.getHostName();
        try {
            country = country.substring(country.lastIndexOf(".") + 1);
            if (country.equals("at")) {
                this.m_Locale = new Locale("de", "AT");
                return;
            }
            if (country.equals("de")) {
                this.m_Locale = new Locale("de", "DE");
                return;
            }
            if (country.equals("mx")) {
                this.m_Locale = new Locale("es", "MX");
                return;
            }
            if (country.equals("es")) {
                this.m_Locale = new Locale("es", "ES");
                return;
            }
            if (country.equals("it")) {
                this.m_Locale = Locale.ITALY;
                return;
            }
            if (country.equals("fr")) {
                this.m_Locale = Locale.FRANCE;
                return;
            }
            if (country.equals("uk")) {
                this.m_Locale = new Locale("en", "GB");
                return;
            }
            if (country.equals("arpa")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (country.equals("com")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (country.equals("edu")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (country.equals("gov")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (country.equals("org")) {
                this.m_Locale = Locale.US;
                return;
            }
            if (country.equals("mil")) {
                this.m_Locale = Locale.US;
                return;
            }
            this.m_Locale = Locale.ENGLISH;
        }
        catch (Exception ex) {
            this.m_Locale = Locale.ENGLISH;
        }
    }
}

