/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ByteArrayMaker;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    public static void copyProperties(Properties from, Properties to) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties fromMap(Map map) {
        if (map instanceof Properties) {
            return (Properties)map;
        }
        Properties p = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            p.setProperty(key, value);
        }
        return p;
    }

    public static void fromProperties(Properties p, Map map) {
        map.clear();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static Properties load(String s) throws IOException {
        Properties p = new Properties();
        PropertiesUtil.load(p, s);
        return p;
    }

    public static void load(Properties p, String s) throws IOException {
        if (Validator.isNotNull(s)) {
            s = UnicodeFormatter.toString(s);
            s = StringUtil.replace(s, "\\u003d", "=");
            s = StringUtil.replace(s, "\\u000a", "\n");
            s = StringUtil.replace(s, "\\u0021", "!");
            s = StringUtil.replace(s, "\\u0023", "#");
            s = StringUtil.replace(s, "\\u0020", " ");
            s = StringUtil.replace(s, "\\u005c", "\\");
            p.load(new ByteArrayInputStream(s.getBytes()));
            ArrayList<?> propertyNames = Collections.list(p.propertyNames());
            for (int i = 0; i < propertyNames.size(); ++i) {
                String key = (String)propertyNames.get(i);
                String value = p.getProperty(key);
                if (value == null) continue;
                value = value.trim();
                p.setProperty(key, value);
            }
        }
    }

    public static void merge(Properties p1, Properties p2) {
        Enumeration<?> enu = p2.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p2.getProperty(key);
            p1.setProperty(key, value);
        }
    }

    public static String list(Map map) {
        Properties props = PropertiesUtil.fromMap(map);
        ByteArrayMaker bam = new ByteArrayMaker();
        PrintStream ps = new PrintStream(bam);
        props.list(ps);
        return bam.toString();
    }

    public static void list(Map map, PrintStream out) {
        Properties props = PropertiesUtil.fromMap(map);
        props.list(out);
    }

    public static void list(Map map, PrintWriter out) {
        Properties props = PropertiesUtil.fromMap(map);
        props.list(out);
    }

    public static String toString(Properties p) {
        SafeProperties safeProperties = null;
        if (p instanceof SafeProperties) {
            safeProperties = (SafeProperties)p;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            sb.append(key);
            sb.append("=");
            if (safeProperties != null) {
                sb.append(safeProperties.getEncodedProperty(key));
            } else {
                sb.append(p.getProperty(key));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void trimKeys(Properties p) {
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p.getProperty(key);
            String trimmedKey = key.trim();
            if (key.equals(trimmedKey)) continue;
            p.remove(key);
            p.setProperty(trimmedKey, value);
        }
    }
}

