/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.Sort;

public class SearchEngineUtil {
    public static final int ALL_POS = -1;
    private static final Sort[] _DEFAULT_SORT = new Sort[]{new Sort("modified", 6, true)};
    private static String _defaultSearchEngineName;
    private static SearchEngine _searchEngine;
    private static SearchPermissionChecker _searchPermissionChecker;

    public static void addDocument(long companyId, Document doc) throws SearchException {
        _searchPermissionChecker.addPermissionFields(companyId, doc);
        SearchEngineUtil.getSearchEngine().getWriter().addDocument(companyId, doc);
    }

    public static void deleteDocument(long companyId, String uid) throws SearchException {
        SearchEngineUtil.getSearchEngine().getWriter().deleteDocument(companyId, uid);
    }

    public static void deletePortletDocuments(long companyId, String portletId) throws SearchException {
        SearchEngineUtil.getSearchEngine().getWriter().deletePortletDocuments(companyId, portletId);
    }

    public static SearchEngine getSearchEngine() {
        return _searchEngine;
    }

    public static boolean isIndexReadOnly() {
        return SearchEngineUtil.getSearchEngine().isIndexReadOnly();
    }

    public static void register(String name) {
        SearchEngineUtil.getSearchEngine().register(name);
    }

    public static void registerDefaultSearchEngine() {
        SearchEngineUtil.register(_defaultSearchEngineName);
    }

    public static Hits search(long companyId, Query query, int start, int end) throws SearchException {
        return SearchEngineUtil.getSearchEngine().getSearcher().search(companyId, query, _DEFAULT_SORT, start, end);
    }

    public static Hits search(long companyId, Query query, Sort sort, int start, int end) throws SearchException {
        return SearchEngineUtil.getSearchEngine().getSearcher().search(companyId, query, new Sort[]{sort}, start, end);
    }

    public static Hits search(long companyId, Query query, Sort[] sorts, int start, int end) throws SearchException {
        return SearchEngineUtil.getSearchEngine().getSearcher().search(companyId, query, sorts, start, end);
    }

    public static Hits search(long companyId, long groupId, long userId, String className, Query query, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupId, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, _DEFAULT_SORT, start, end);
    }

    public static Hits search(long companyId, long groupId, long userId, String className, Query query, Sort sort, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupId, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, sort, start, end);
    }

    public static Hits search(long companyId, long groupId, long userId, String className, Query query, Sort[] sorts, int start, int end) throws SearchException {
        if (userId > 0L) {
            query = _searchPermissionChecker.getPermissionQuery(companyId, groupId, userId, className, query);
        }
        return SearchEngineUtil.search(companyId, query, sorts, start, end);
    }

    public static void unregister(String fromName) {
        SearchEngineUtil.getSearchEngine().unregister(fromName);
    }

    public static void updateDocument(long companyId, String uid, Document doc) throws SearchException {
        _searchPermissionChecker.addPermissionFields(companyId, doc);
        SearchEngineUtil.getSearchEngine().getWriter().updateDocument(companyId, uid, doc);
    }

    public static void updatePermissionFields(long resourceId) {
        _searchPermissionChecker.updatePermissionFields(resourceId);
    }

    public void setDefaultSearchEngineName(String defaultSearchEngineName) {
        _defaultSearchEngineName = defaultSearchEngineName;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        _searchEngine = searchEngine;
    }

    public void setSearchPermissionChecker(SearchPermissionChecker searchPermissionChecker) {
        _searchPermissionChecker = searchPermissionChecker;
    }
}

