/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.jmx;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManagerMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DestinationStatisticsManager
implements DestinationStatisticsManagerMBean {
    private static final String _OBJECT_NAME_PREFIX = "com.liferay.portal.kernel.messaging:type=DestinationStatistics,name=";
    private boolean _autoRefresh;
    private Destination _destination;
    private long _lastRefresh;
    private DestinationStatistics _statistics;

    public static ObjectName createObjectName(String destinationName) {
        try {
            return new ObjectName(_OBJECT_NAME_PREFIX + destinationName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalStateException(mone);
        }
    }

    public DestinationStatisticsManager(Destination destination) {
        this._destination = destination;
    }

    public int getActiveThreadCount() {
        if (this._autoRefresh) {
            this.refresh();
        }
        return this._statistics.getActiveThreadCount();
    }

    public int getCurrentThreadCount() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getCurrentThreadCount();
    }

    public int getLargestThreadCount() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getLargestThreadCount();
    }

    public String getLastRefresh() {
        return String.valueOf(this._lastRefresh);
    }

    public int getMaxThreadPoolSize() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getMaxThreadPoolSize();
    }

    public int getMinThreadPoolSize() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getMinThreadPoolSize();
    }

    public long getPendingMessageCount() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getPendingMessageCount();
    }

    public long getSentMessageCount() {
        if (this._autoRefresh || this._statistics == null) {
            this.refresh();
        }
        return this._statistics.getSentMessageCount();
    }

    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    public void refresh() {
        if (System.currentTimeMillis() > this._lastRefresh) {
            this._lastRefresh = System.currentTimeMillis();
            this._statistics = this._destination.getStatistics();
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this._autoRefresh = autoRefresh;
    }
}

