/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.ConcurrentHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorDispatcherDestination
extends BaseDestination {
    private static Log _log = LogFactoryUtil.getLog(BaseDestination.class);
    private Set<MessageListener> _listeners = new ConcurrentHashSet<MessageListener>();

    public IteratorDispatcherDestination(String name) {
        super(name);
    }

    public IteratorDispatcherDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    @Override
    public void register(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        this._listeners.add(listener);
        this.setListenerCount(this._listeners.size());
    }

    @Override
    public void send(Message message) {
        if (this._listeners.size() == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug("No listeners for destination " + this.getName());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException("Destination " + this.getName() + " is shutdown and cannot " + "receive more messages");
        }
        this.dispatch(this._listeners.iterator(), message);
    }

    @Override
    public boolean unregister(MessageListener listener) {
        listener = new InvokerMessageListener(listener);
        boolean value = this._listeners.remove(listener);
        this.setListenerCount(this._listeners.size());
        return value;
    }

    protected abstract void dispatch(Iterator<MessageListener> var1, Message var2);
}

