/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageBus
implements MessageBus {
    private static Log _log = LogFactoryUtil.getLog(DefaultMessageBus.class);
    private Map<String, Destination> _destinations = new HashMap<String, Destination>();
    private List<DestinationEventListener> _destinationEventListeners = new ArrayList<DestinationEventListener>();

    @Override
    public synchronized void addDestination(Destination destination) {
        this._destinations.put(destination.getName(), destination);
        this.fireDestinationAddedEvent(destination);
    }

    @Override
    public void addDestinationEventListener(DestinationEventListener listener) {
        this._destinationEventListeners.add(listener);
    }

    public void destroy() {
        this.shutdown(true);
    }

    @Override
    public int getDestinationCount() {
        return this._destinations.size();
    }

    @Override
    public Collection<String> getDestinationNames() {
        return this._destinations.keySet();
    }

    @Override
    public Collection<Destination> getDestinations() {
        return this._destinations.values();
    }

    @Override
    public boolean hasDestination(String destinationName) {
        return this._destinations.containsKey(destinationName);
    }

    @Override
    public boolean hasMessageListener(String destination) {
        Destination destinationModel = this._destinations.get(destination);
        return destinationModel != null && destinationModel.isRegistered();
    }

    @Override
    public synchronized void registerMessageListener(String destination, MessageListener listener) {
        Destination destinationModel = this._destinations.get(destination);
        if (destinationModel == null) {
            throw new IllegalStateException("Destination " + destination + " is not configured");
        }
        destinationModel.register(listener);
    }

    @Override
    public synchronized void removeDestination(String destination) {
        Destination destinationModel = this._destinations.remove(destination);
        this.fireDestinationRemovedEvent(destinationModel);
    }

    @Override
    public void removeDestinationEventListener(DestinationEventListener listener) {
        this._destinationEventListeners.remove(listener);
    }

    @Override
    public void sendMessage(String destination, Message message) {
        Destination destinationModel = this._destinations.get(destination);
        if (destinationModel == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Destination " + destination + " is not configured");
            }
            return;
        }
        message.setDestination(destination);
        destinationModel.send(message);
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public synchronized void shutdown(boolean force) {
        for (Destination destination : this._destinations.values()) {
            destination.close(force);
        }
    }

    @Override
    public synchronized boolean unregisterMessageListener(String destination, MessageListener listener) {
        Destination destinationModel = this._destinations.get(destination);
        if (destinationModel == null) {
            return false;
        }
        return destinationModel.unregister(listener);
    }

    protected void fireDestinationAddedEvent(Destination destination) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.destinationAdded(destination);
        }
    }

    protected void fireDestinationRemovedEvent(Destination destination) {
        for (DestinationEventListener listener : this._destinationEventListeners) {
            listener.destinationRemoved(destination);
        }
    }
}

