/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContainer<R> {
    public static final int DEFAULT_CUR = 1;
    public static final String DEFAULT_CUR_PARAM = "cur";
    public static final int DEFAULT_CUR_VALUE = 1;
    public static final int DEFAULT_DELTA = 20;
    public static final String DEFAULT_DELTA_PARAM = "delta";
    public static final int DEFAULT_MAX_PAGES = 25;
    public static final String DEFAULT_ORDER_BY_COL_PARAM = "orderByCol";
    public static final String DEFAULT_ORDER_BY_TYPE_PARAM = "orderByType";
    public static final int MAX_DELTA = 200;
    private String _id;
    private DisplayTerms _displayTerms;
    private DisplayTerms _searchTerms;
    private int _cur;
    private String _curParam = "cur";
    private int _delta = 20;
    private String _deltaParam = "delta";
    private int _maxPages = 25;
    private int _start;
    private int _end;
    private int _resultEnd;
    private int _total;
    private List<R> _results = new ArrayList<R>();
    private List<ResultRow> _resultRows = new ArrayList<ResultRow>();
    private PortletURL _iteratorURL;
    private List<String> _headerNames;
    private Map<String, String> _orderableHeaders;
    private String _orderByCol;
    private String _orderByColParam = "orderByCol";
    private String _orderByType;
    private String _orderByTypeParam = "orderByType";
    private OrderByComparator _orderByComparator;
    private String _emptyResultsMessage;
    private RowChecker _rowChecker;
    private boolean _hover = true;

    public SearchContainer() {
    }

    public SearchContainer(PortletRequest portletRequest, DisplayTerms displayTerms, DisplayTerms searchTerms, String curParam, int delta, PortletURL iteratorURL, List<String> headerNames, String emptyResultsMessage) {
        this._displayTerms = displayTerms;
        this._searchTerms = searchTerms;
        this._curParam = curParam;
        this._cur = ParamUtil.getInteger(portletRequest, this._curParam, 1);
        if (this._cur < 1) {
            this._cur = 1;
        }
        this.setDelta(ParamUtil.getInteger(portletRequest, this._deltaParam, delta));
        this._iteratorURL = iteratorURL;
        this._iteratorURL.setParameter(this._curParam, String.valueOf(this._cur));
        this._iteratorURL.setParameter(this._deltaParam, String.valueOf(this._delta));
        this._iteratorURL.setParameter("keywords", ParamUtil.getString(portletRequest, "keywords"));
        this._iteratorURL.setParameter("advancedSearch", String.valueOf(ParamUtil.getBoolean(portletRequest, "advancedSearch")));
        this._iteratorURL.setParameter("andOperator", String.valueOf(ParamUtil.getBoolean(portletRequest, "andOperator", true)));
        if (headerNames != null) {
            this._headerNames = new ArrayList<String>(headerNames.size());
            this._headerNames.addAll(headerNames);
        }
        this._emptyResultsMessage = emptyResultsMessage;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public DisplayTerms getDisplayTerms() {
        return this._displayTerms;
    }

    public DisplayTerms getSearchTerms() {
        return this._searchTerms;
    }

    public int getCur() {
        return this._cur;
    }

    public String getCurParam() {
        return this._curParam;
    }

    public int getCurValue() {
        return this.getCur();
    }

    public int getDelta() {
        return this._delta;
    }

    public void setDelta(int delta) {
        this._delta = delta <= 0 ? 20 : (delta > 200 ? 200 : delta);
        this._calculateStartAndEnd();
    }

    public String getDeltaParam() {
        return this._deltaParam;
    }

    public void setDeltaParam(String deltaParam) {
        this._deltaParam = deltaParam;
    }

    public int getMaxPages() {
        return this._maxPages;
    }

    public void setMaxPages(int maxPages) {
        this._maxPages = maxPages;
    }

    public int getStart() {
        return this._start;
    }

    public int getEnd() {
        return this._end;
    }

    public int getResultEnd() {
        return this._resultEnd;
    }

    public int getTotal() {
        return this._total;
    }

    public void setTotal(int total) {
        this._total = total;
        if ((this._cur - 1) * this._delta > this._total) {
            this._cur = 1;
        }
        this._calculateStartAndEnd();
    }

    public List<R> getResults() {
        return this._results;
    }

    public void setResults(List<R> results) {
        this._results = results;
    }

    public List<ResultRow> getResultRows() {
        return this._resultRows;
    }

    public PortletURL getIteratorURL() {
        return this._iteratorURL;
    }

    public void setIteratorURL(PortletURL iteratorURL) {
        this._iteratorURL = iteratorURL;
    }

    public List<String> getHeaderNames() {
        return this._headerNames;
    }

    public void setHeaderNames(List<String> headerNames) {
        this._headerNames = headerNames;
    }

    public Map<String, String> getOrderableHeaders() {
        return this._orderableHeaders;
    }

    public void setOrderableHeaders(Map<String, String> orderableHeaders) {
        this._orderableHeaders = orderableHeaders;
    }

    public String getOrderByCol() {
        return this._orderByCol;
    }

    public void setOrderByCol(String orderByCol) {
        this._orderByCol = orderByCol;
        this._iteratorURL.setParameter(this._orderByColParam, this._orderByCol);
    }

    public String getOrderByColParam() {
        return this._orderByColParam;
    }

    public void setOrderByColParam(String orderByColParam) {
        this._orderByColParam = orderByColParam;
    }

    public String getOrderByType() {
        return this._orderByType;
    }

    public void setOrderByType(String orderByType) {
        this._orderByType = orderByType;
        this._iteratorURL.setParameter(this._orderByTypeParam, this._orderByType);
    }

    public String getOrderByTypeParam() {
        return this._orderByTypeParam;
    }

    public void setOrderByTypeParam(String orderByTypeParam) {
        this._orderByTypeParam = orderByTypeParam;
    }

    public OrderByComparator getOrderByComparator() {
        return this._orderByComparator;
    }

    public void setOrderByComparator(OrderByComparator orderByComparator) {
        this._orderByComparator = orderByComparator;
    }

    public String getEmptyResultsMessage() {
        return this._emptyResultsMessage;
    }

    public void setEmptyResultsMessage(String emptyResultsMessage) {
        this._emptyResultsMessage = emptyResultsMessage;
    }

    public RowChecker getRowChecker() {
        return this._rowChecker;
    }

    public void setRowChecker(RowChecker rowChecker) {
        this._rowChecker = rowChecker;
    }

    public boolean isHover() {
        return this._hover;
    }

    public void setHover(boolean hover) {
        this._hover = hover;
    }

    private void _calculateStartAndEnd() {
        this._start = (this._cur - 1) * this._delta;
        this._resultEnd = this._end = this._start + this._delta;
        if (this._resultEnd > this._total) {
            this._resultEnd = this._total;
        }
    }
}

