/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataAccess {
    private static Log _log = LogFactoryUtil.getLog(DataAccess.class);

    public static Connection getConnection() throws SQLException {
        DataSource ds = InfrastructureUtil.getDataSource();
        return ds.getConnection();
    }

    public static Connection getConnection(String location) throws NamingException, SQLException {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)JNDIUtil.lookup(ctx, location);
        return ds.getConnection();
    }

    public static void cleanUp(Connection con) {
        DataAccess.cleanUp(con, null, null);
    }

    public static void cleanUp(Connection con, Statement s) {
        DataAccess.cleanUp(con, s, null);
    }

    public static void cleanUp(Connection con, Statement s, ResultSet rs) {
        block11: {
            block10: {
                block9: {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sqle) {
                        if (!_log.isWarnEnabled()) break block9;
                        _log.warn(sqle.getMessage());
                    }
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (SQLException sqle) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn(sqle.getMessage());
                }
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn(sqle.getMessage());
            }
        }
    }
}

