/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.warnning;

import org.apache.log4j.spi.LoggingEvent;

public class ErrorCondition {
    public static final String TYPE_EXACTLY = "EXACTLY";
    public static final String TYPE_ATLEAST = "ATLEAST";
    public static final String TYPE_ALL = "ALL";
    public static final String LOGFIELD_LEVEL = "LOGLEVEL";
    public static final String LOGFIELD_LOGGERNAME = "LOGGERNAME";
    public static final String LOGFIELD_MESSAGE = "MESSAGE";
    public static final String LOGFIELD_THREADNAME = "THREADNAME";
    private String type;
    private String logField;
    private String value;
    private String[] values = null;

    public ErrorCondition() {
    }

    public ErrorCondition(String logField, String condition) {
        this.logField = logField;
        if (condition.startsWith(TYPE_ALL)) {
            this.type = TYPE_ALL;
            this.value = condition.substring(TYPE_ALL.length()).trim();
            this.values = this.value.split("\\|");
        } else if (condition.startsWith(TYPE_ATLEAST)) {
            this.type = TYPE_ATLEAST;
            this.value = condition.substring(TYPE_ATLEAST.length()).trim();
            this.values = this.value.split("\\|");
        } else if (condition.startsWith(TYPE_EXACTLY)) {
            this.type = TYPE_EXACTLY;
            this.value = condition.substring(TYPE_EXACTLY.length()).trim();
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = this.values[i].trim();
            }
        }
    }

    public ErrorCondition(String type, String logField, String value) {
        this.type = type;
        this.logField = logField;
        this.value = value;
    }

    public String getLogField() {
        return this.logField;
    }

    public void setLogField(String logField) {
        this.logField = logField;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.logField + " " + this.type + " " + this.value;
    }

    public boolean match(LoggingEvent loggingEvent) {
        if (this.logField.equals(LOGFIELD_LEVEL)) {
            return this.value.contains(loggingEvent.getLevel().toString());
        }
        if (this.logField.equals(LOGFIELD_LOGGERNAME)) {
            String loggerName = loggingEvent.getLoggerName();
            if (loggerName == null) {
                return false;
            }
            loggerName = loggerName.trim();
            if (this.type.equals(TYPE_EXACTLY)) {
                return loggerName.equals(this.value);
            }
            if (this.type.equals(TYPE_ATLEAST)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (!loggerName.contains(this.values[i])) continue;
                    return true;
                }
                return false;
            }
            if (this.type.equals(TYPE_ALL)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (loggerName.contains(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.logField.equals(LOGFIELD_MESSAGE)) {
            String message = loggingEvent.getMessage().toString();
            if (message == null) {
                return false;
            }
            message = message.trim();
            if (this.type.equals(TYPE_EXACTLY)) {
                return message.equals(this.value);
            }
            if (this.type.equals(TYPE_ATLEAST)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (!message.contains(this.values[i])) continue;
                    return true;
                }
                return false;
            }
            if (this.type.equals(TYPE_ALL)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (message.contains(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.logField.equals(LOGFIELD_THREADNAME)) {
            String threadName = loggingEvent.getThreadName();
            if (threadName == null) {
                return false;
            }
            threadName = threadName.trim();
            if (this.type.equals(TYPE_EXACTLY)) {
                return threadName.equals(this.value);
            }
            if (this.type.equals(TYPE_ATLEAST)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (!threadName.contains(this.values[i])) continue;
                    return true;
                }
                return false;
            }
            if (this.type.equals(TYPE_ALL)) {
                int length = this.values.length;
                for (int i = 0; i < length; ++i) {
                    if (threadName.contains(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

