/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.database;

import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.database.DataStore;
import com.viettel.security.PassTranformer;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnection {
    private Properties properties = new Properties();
    private static DatabaseConnection instance = null;
    private String driverName = "";
    private String connectionUri = "";
    private String username = "";
    private String password = "";
    private String schema = "";
    private String sqlCheck = "";
    private Connection connection = null;
    private DataStore datastore = null;
    private final Object lock = new Object();

    private DatabaseConnection(String config) {
        try {
            this.properties.load(new FileInputStream(config));
            this.driverName = PassTranformer.decrypt((String)this.properties.getProperty("driver"));
            this.connectionUri = PassTranformer.decrypt((String)this.properties.getProperty("connection"));
            this.schema = PassTranformer.decrypt((String)this.properties.getProperty("schema"));
            this.username = PassTranformer.decrypt((String)this.properties.getProperty("username"));
            this.password = PassTranformer.decrypt((String)this.properties.getProperty("password"));
            this.sqlCheck = this.properties.getProperty("sqlcheck");
            this.datastore = new DataStore(this.driverName, this.connectionUri, this.username, this.password, this.sqlCheck, false);
            this.connection = this.datastore.getConnection();
        }
        catch (Exception ex) {
            Log.error("Can not create connection " + ex.toString());
        }
    }

    public static DatabaseConnection shareInstance() {
        String config = System.getProperty("com.viettel.mmserver.db.path");
        if (config == null) {
            return null;
        }
        if (instance == null) {
            instance = new DatabaseConnection(config);
        }
        return instance;
    }

    public Connection updateConnection() {
        try {
            this.connection = this.datastore.getConnection();
            Log.debug("create db connection");
        }
        catch (SQLException ex) {
            Log.error("Error when update connection " + ex);
        }
        return this.connection;
    }

    public boolean checkConnection() {
        return false;
    }

    public String getSchema() {
        return this.schema;
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.datastore.getConnection();
            }
        }
        catch (SQLException ex) {
            Log.error("exception when get database connection " + ex);
        }
        return this.connection;
    }
}

