/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.agent;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.agent.MmJMXServerSecMBean;
import com.viettel.mmserver.authenticator.ActionLogDbUtils;
import com.viettel.mmserver.authenticator.MmAuthenticator;
import com.viettel.mmserver.authenticator.MmUser;
import com.viettel.mmserver.base.ConfigParam;
import com.viettel.mmserver.base.Log;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MmJMXServerSec
implements MmJMXServerSecMBean,
NotificationEmitter {
    private static MmJMXServerSec instance;
    private static String appId;
    private ActionLogDbUtils actionLogDbUtils;
    protected NotificationBroadcasterSupport notificationHandler;
    private static String ip;
    private static int port;
    private static Logger log;
    private static Hashtable<String, MmUser> userMap;
    private JMXConnectorServer cs;

    public static MmJMXServerSec getInstance() {
        if (instance == null) {
            instance = new MmJMXServerSec();
        }
        return instance;
    }

    public void reload() {
    }

    public static String getIp() {
        return ip;
    }

    public static void setIp(String ip) {
        MmJMXServerSec.ip = ip;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        MmJMXServerSec.port = port;
    }

    private MmJMXServerSec() {
        if (this.notificationHandler == null) {
            this.notificationHandler = new NotificationBroadcasterSupport();
        }
        try {
            MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=JMXConnector"));
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        appId = ConfigParam.getInstance().getAppID();
    }

    public void start() throws MalformedURLException, IOException {
        String actionLog = System.getProperty("com.viettel.mmserver.actionLog");
        if ((actionLog == null || actionLog.trim().equals("1")) && this.actionLogDbUtils == null) {
            this.actionLogDbUtils = new ActionLogDbUtils("actionlog");
        }
        if (this.cs != null) {
            throw new IllegalStateException("start must be call only one");
        }
        String authenticate = "on";
        authenticate = System.getProperty("com.viettel.mmserver.agent.authenticate", "on").trim();
        HashMap<String, RealmJMXAuthenticator> env = new HashMap<String, RealmJMXAuthenticator>();
        if (!ConfigParam.getInstance().getAppID().equals("")) {
            if (authenticate.equals("off")) {
                log.info((Object)"Authenticating was off, so no authenticator and authorization");
            } else {
                log.info((Object)"Init Authenticator");
                env.put("jmx.remote.authenticator", new RealmJMXAuthenticator());
            }
        } else {
            log.info((Object)"No appID, so no authenticator and authorization!");
        }
        if (ip == null) {
            ip = "0.0.0.0";
        }
        System.setProperty("java.rmi.server.randomIDs", "true");
        LocateRegistry.createRegistry(port);
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + ip + ":" + (port + 1) + "/jndi/rmi://" + ip + ":" + port + "/jmxrmi");
        MBeanServer mbs = MMbeanServer.getInstance();
        log.info((Object)"Creating JMX Url connection");
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        if (!ConfigParam.getInstance().getAppID().equals("")) {
            log.info((Object)"Creating MBean Server Forwarder");
            MBeanServerForwarder mbsf = MBSFInvocationHandler.newProxyInstance();
            this.cs.setMBeanServerForwarder(mbsf);
        }
        try {
            if (this.actionLogDbUtils != null) {
                this.addNotificationListener(this.actionLogDbUtils, null, null);
            }
        }
        catch (Exception ex) {
            log.info((Object)ex);
        }
        this.cs.start();
        log.info((Object)"Started succesfully");
    }

    public void stop() {
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LogManager.shutdown();
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notificationHandler.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] dNotifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"Method Invoke"}, Notification.class.getName(), "notification when method invoked remotely")};
        return dNotifications;
    }

    private static String getLogMsg(String msg, Object[] args) {
        StringBuilder sb = new StringBuilder(msg);
        String indent = "\t\t\t\t";
        if (args != null) {
            sb.append("\r\n");
            sb.append(indent + "<args>\r\n");
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                sb.append(indent + "   <" + args[i].getClass().getName() + ">" + MmJMXServerSec.getObString(args[i]) + "</>\r\n");
            }
            sb.append(indent + "</args>");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private static String getObString(Object o) {
        if (o != null) {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof String[]) {
                String[] tmp = (String[])o;
                StringBuilder sb = new StringBuilder();
                for (String s : tmp) {
                    sb.append(s + "   ");
                }
                return sb.toString();
            }
            return o.toString();
        }
        return null;
    }

    public static boolean matchRule(String mbeanName, String rule) {
        if (rule == null) {
            return false;
        }
        if ((rule = rule.trim()).endsWith("*") && rule.length() > 1) {
            return mbeanName.startsWith(rule.substring(0, rule.length() - 1));
        }
        return false;
    }

    public void sendNotification(Notification notification) {
        this.notificationHandler.sendNotification(notification);
    }

    static {
        port = 9000;
        log = Logger.getLogger((String)"mbeanserver");
        userMap = new Hashtable();
    }

    public static class MBSFInvocationHandler
    implements InvocationHandler {
        public static final String TYPE = "method.invoke";
        private MBeanServer mbs;

        public static MBeanServerForwarder newProxyInstance() {
            MBSFInvocationHandler handler = new MBSFInvocationHandler();
            Class[] interfaces = new Class[]{MBeanServerForwarder.class};
            Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
            return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Set<JMXPrincipal> principals;
                String methodName = method.getName();
                if (methodName.equals("getMBeanServer")) {
                    log.debug((Object)"getMBeanServer return");
                    return this.mbs;
                }
                if (methodName.equals("setMBeanServer")) {
                    if (args[0] == null) {
                        log.warn((Object)"setMBeanServer return by null");
                        throw new IllegalArgumentException("Null MBeanServer");
                    }
                    if (this.mbs != null) {
                        log.warn((Object)"already initialized");
                        throw new IllegalArgumentException("MBeanServer object already initialized");
                    }
                    this.mbs = (MBeanServer)args[0];
                    log.debug((Object)"setMBeanServer return");
                    return null;
                }
                AccessControlContext acc = AccessController.getContext();
                Subject subject = Subject.getSubject(acc);
                if (subject == null) {
                    return method.invoke((Object)this.mbs, args);
                }
                if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
                    log.warn((Object)"Access to \"createMBean\" and \"unregisterMBean\" restricted");
                    throw new SecurityException("Access denied");
                }
                if (args != null && args[0] instanceof ObjectName) {
                    ObjectName o = (ObjectName)args[0];
                    if (o.getDomain().equals("java.lang") || o.getDomain().equals("com.sun.management") || o.getDomain().equals("JMImplementation") || o.getDomain().equals("java.util.logging") || o.getDomain().equals("Log")) {
                        return method.invoke((Object)this.mbs, args);
                    }
                    if (o.toString().equals("Tools:name=MmAuthenticator") || o.toString().equals("Tools:name=BlockedDetector") || o.toString().equals("Tools:name=StatusCollector")) {
                        return method.invoke((Object)this.mbs, args);
                    }
                }
                if ((principals = subject.getPrincipals(JMXPrincipal.class)) == null || principals.isEmpty()) {
                    log.warn((Object)"No principal, access denied");
                    throw new SecurityException("Access denied");
                }
                Principal principal = principals.iterator().next();
                String identity = principal.getName();
                if (args != null && args.length == 4 && args[0] != null && args[0] instanceof ObjectName && args[1] != null && args[1] instanceof String) {
                    ObjectName o = (ObjectName)args[0];
                    String strObjectName = o.toString();
                    String strMethod = (String)args[1];
                    log.debug((Object)(identity + " invokes method " + strMethod + " of " + o.toString()));
                    String param = "";
                    if (args[2] != null) {
                        Object[] params = (Object[])args[2];
                        for (int i = 0; i < params.length; ++i) {
                            param = param + params[i].toString() + ",";
                        }
                        if (!param.equals("")) {
                            param = param.substring(0, param.length() - 1);
                        }
                    }
                    if (strObjectName != null && !strObjectName.equals("") && strMethod != null && !strMethod.equals("")) {
                        MmUser mmUser = (MmUser)userMap.get(identity);
                        if (mmUser != null) {
                            Hashtable<String, List<String>> objectList = mmUser.getRoleMap();
                            List<String> methodList = objectList.get(strObjectName);
                            boolean hasPrivilege = false;
                            if (methodList != null) {
                                for (int i = 0; i < methodList.size(); ++i) {
                                    if (!methodList.get(i).equals(strMethod)) continue;
                                    hasPrivilege = true;
                                    break;
                                }
                            } else {
                                Set<Map.Entry<String, List<String>>> roleSet = objectList.entrySet();
                                for (Map.Entry<String, List<String>> entry : roleSet) {
                                    List<String> methodList_;
                                    if (MmJMXServerSec.matchRule(strObjectName, entry.getKey()) && (methodList_ = entry.getValue()) != null) {
                                        for (int i = 0; i < methodList_.size(); ++i) {
                                            if (!methodList_.get(i).equals(strMethod)) continue;
                                            hasPrivilege = true;
                                            break;
                                        }
                                    }
                                    if (!hasPrivilege) continue;
                                    break;
                                }
                            }
                            if (hasPrivilege) {
                                Notification notification;
                                try {
                                    Object result = method.invoke((Object)this.mbs, args);
                                    notification = new Notification(TYPE, (Object)identity, 0L, appId + "\t" + strMethod + "\t" + param + "\t" + strObjectName + "\t" + "success" + "\t" + Long.toString(Calendar.getInstance().getTimeInMillis()));
                                    MmJMXServerSec.getInstance().notificationHandler.sendNotification(notification);
                                    return result;
                                }
                                catch (Exception ex) {
                                    notification = new Notification(TYPE, (Object)identity, 0L, appId + "\t" + strMethod + "\t" + param + "\t" + strObjectName + "\t" + "unsuccess" + "\t" + Long.toString(Calendar.getInstance().getTimeInMillis()));
                                    MmJMXServerSec.getInstance().notificationHandler.sendNotification(notification);
                                    throw ex;
                                }
                            }
                            log.warn((Object)("No permission, access denied to method " + args[1] + " of mbean " + args[0]));
                            throw new SecurityException("Access denied");
                        }
                        log.warn((Object)"No permission, access denied");
                        throw new SecurityException("Access denied");
                    }
                }
                log.debug((Object)(identity + MmJMXServerSec.getLogMsg(" invoke " + methodName, args)));
                return method.invoke((Object)this.mbs, args);
            }
            catch (Throwable e) {
                log.warn((Object)"more error", e);
                throw e;
            }
        }
    }

    public static class RealmJMXAuthenticator
    implements JMXAuthenticator {
        public Subject authenticate(Object credentials) {
            log.info((Object)"Authenticating!!!");
            if (credentials == null) {
                log.warn((Object)"Credentials required");
                throw new SecurityException("Credentials required");
            }
            if (!(credentials instanceof String[])) {
                log.warn((Object)"Credentials should be String[]");
                throw new SecurityException("Credentials should be String[]");
            }
            String[] aCredentials = (String[])credentials;
            if (aCredentials.length < 2) {
                log.warn((Object)"Credentials should have username/password");
                throw new SecurityException("Credentials should have username/password");
            }
            String username = aCredentials[0];
            String password = aCredentials[1];
            MmUser mmUser = null;
            try {
                mmUser = MmAuthenticator.getInstance().validate(username, password, appId);
            }
            catch (Exception ex) {
                log.error((Object)"Error in validate user");
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                Log.error("Error in validate user");
                ex.printStackTrace();
                Log.error(ex);
                throw new SecurityException(ex);
            }
            try {
                if (mmUser != null) {
                    userMap.put(username, mmUser);
                    log.info((Object)(username + " authenticated"));
                    return new Subject(true, Collections.singleton(new JMXPrincipal(aCredentials[0])), Collections.EMPTY_SET, Collections.EMPTY_SET);
                }
                log.warn((Object)(username + "/" + password + " invalid"));
                throw new SecurityException("Invalid credentials");
            }
            catch (Exception e) {
                log.warn((Object)(username + "/" + password + " authentiacte error"));
                throw new SecurityException("Authenticate error");
            }
        }
    }
}

