/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.filterchain;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;

public class IoFilterEvent
extends IoEvent {
    private final IoFilter.NextFilter nextFilter;

    public IoFilterEvent(IoFilter.NextFilter nextFilter, IoEventType type, IoSession session, Object parameter) {
        super(type, session, parameter);
        if (nextFilter == null) {
            throw new NullPointerException("nextFilter");
        }
        this.nextFilter = nextFilter;
    }

    public IoFilter.NextFilter getNextFilter() {
        return this.nextFilter;
    }

    public void fire() {
        switch (this.getType()) {
            case MESSAGE_RECEIVED: {
                this.getNextFilter().messageReceived(this.getSession(), this.getParameter());
                break;
            }
            case MESSAGE_SENT: {
                this.getNextFilter().messageSent(this.getSession(), (WriteRequest)this.getParameter());
                break;
            }
            case WRITE: {
                this.getNextFilter().filterWrite(this.getSession(), (WriteRequest)this.getParameter());
                break;
            }
            case CLOSE: {
                this.getNextFilter().filterClose(this.getSession());
                break;
            }
            case EXCEPTION_CAUGHT: {
                this.getNextFilter().exceptionCaught(this.getSession(), (Throwable)this.getParameter());
                break;
            }
            case SESSION_IDLE: {
                this.getNextFilter().sessionIdle(this.getSession(), (IdleStatus)this.getParameter());
                break;
            }
            case SESSION_OPENED: {
                this.getNextFilter().sessionOpened(this.getSession());
                break;
            }
            case SESSION_CREATED: {
                this.getNextFilter().sessionCreated(this.getSession());
                break;
            }
            case SESSION_CLOSED: {
                this.getNextFilter().sessionClosed(this.getSession());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)this.getType()));
            }
        }
    }
}

