/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.ExchMsg;
import com.viettel.common.ViettelMsg;
import com.viettel.common.ViettelService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class MsgUtils {
    public static String toConciseString(ExchMsg msg) {
        StringBuffer buff = new StringBuffer();
        String sep = "|";
        buff.append(msg.getSystemTrace());
        buff.append(sep);
        String clientId = msg.getClientId();
        if (clientId != null) {
            buff.append(clientId);
        }
        buff.append(sep);
        String command = msg.getCommand();
        if (command != null) {
            buff.append(command);
        }
        buff.append(sep);
        String exchId = msg.getExchId();
        if (exchId != null) {
            buff.append(exchId);
        }
        buff.append(sep);
        String exchType = msg.getExchType();
        if (exchType != null) {
            buff.append(exchType);
        }
        buff.append(sep);
        buff.append(MsgUtils.getTransactionTime(msg));
        String error = msg.getError();
        buff.append(sep);
        if (error != null) {
            buff.append(error);
        }
        buff.append(sep);
        String description = msg.getDescription();
        if (description != null) {
            buff.append(description);
        }
        buff.append(sep);
        if (msg.fields.size() > 0) {
            Enumeration<String> e = msg.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = msg.get(key);
                if (key == null || value == null) continue;
                buff.append(key + "=" + value + ",");
            }
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    public static String getTransactionTime(ViettelMsg msg) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.SSS");
        Date transactionTime = msg.getTransactionTime();
        if (transactionTime == null) {
            Date dt = new Date();
            return df.format(dt);
        }
        return df.format(transactionTime);
    }

    public static String toConciseString(ViettelService msg) {
        StringBuffer buff = new StringBuffer();
        String sep = "|";
        buff.append(msg.getSystemTrace());
        buff.append(sep);
        String clientId = msg.getClientId();
        if (clientId != null) {
            buff.append(clientId);
        }
        buff.append(sep);
        buff.append(msg.getMessageType());
        buff.append(sep);
        buff.append(msg.getProcessCode());
        buff.append(sep);
        buff.append(MsgUtils.getTransactionTime(msg));
        buff.append(sep);
        String error = msg.getError();
        if (error != null) {
            buff.append(error);
        }
        buff.append(sep);
        if (msg.getFields().size() > 0) {
            Enumeration<String> e = msg.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = msg.get(key);
                if (key == null || value == null || key.equalsIgnoreCase("detail")) continue;
                buff.append(key + "=" + value + ",");
            }
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    public static String getTimeDateFormate(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
        Date dt = new Date(time);
        return formatter.format(dt);
    }
}

