/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.cluster.agent;

import com.viettel.cluster.agent.Dispatcher;
import com.viettel.cluster.agent.utils.ConfigLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

class ClusterAgent
extends ReceiverAdapter {
    private static final long WAIT_IF_FIRST_VIEW_TIME = 5000L;
    private static final long WAIT_TO_NOTIFY_READY = 5000L;
    private JChannel channel;
    private View view;
    private List readyMembersList = new ArrayList();
    private boolean isFirstView = true;
    private ViewChangedHandler viewChangedHandler;
    private final Dispatcher controller;
    private final Logger logger;

    public ClusterAgent(Dispatcher dispatcher) {
        this.controller = dispatcher;
        this.logger = this.controller.getLogger();
        this.viewChangedHandler = new ViewChangedHandler();
    }

    void start() throws ChannelException {
        Properties properties = System.getProperties();
        if (this.controller.getConfigHolder().getIp() != null) {
            properties.setProperty("jgroups.bind_addr", this.controller.getConfigHolder().getIp());
        }
        if (this.controller.getConfigHolder().getPort() != null) {
            properties.setProperty("jgroups.bind_port", this.controller.getConfigHolder().getPort());
        }
        if (this.controller.getConfigHolder().getInitialHosts() == null) {
            throw new ChannelException("Have to set first member of cluster in a configuration file before start");
        }
        properties.setProperty("jgroups.tcpping.initial_hosts", this.controller.getConfigHolder().getInitialHosts());
        if (properties.getProperty("java.net.preferIPv4Stack") == null || !properties.getProperty("java.net.preferIPv4Stack").equals("true")) {
            throw new ChannelException("Have to set -Djava.net.preferIPv4Stack=true before JVM initializes");
        }
        this.channel = new JChannel(this.controller.getConfigHolder().getProtocolStack());
        this.channel.setName(this.controller.getConfigHolder().getNodeName());
        this.channel.setReceiver((Receiver)this);
        this.channel.connect(this.controller.getConfigHolder().getClusterName());
    }

    void destroy() {
        this.channel.disconnect();
        this.channel.close();
    }

    public void viewAccepted(View newView) {
        this.logger.debug((Object)("New view: " + newView));
        if (this.view != null) {
            if (this.view.getMembers().size() >= newView.getMembers().size()) {
                this.logger.warn((Object)ConfigLoader.reducedView);
            } else {
                this.logger.warn((Object)ConfigLoader.increasedView);
            }
        }
        this.view = newView;
        this.readyMembersList.clear();
        this.controller.getExecutor().execute(this.viewChangedHandler);
    }

    public void receive(Message msg) {
        this.logger.debug((Object)("Receives a message " + msg.getObject() + " from " + msg.getSrc()));
        if (msg.getObject().equals(this.view.getViewId()) && this.addToReadyMembersList(msg.getSrc().toString()) && this.readyMembersList.size() == this.view.size() && this.controller != null) {
            this.controller.onReady();
        }
    }

    private boolean addToReadyMembersList(String src) {
        boolean result = true;
        for (int i = 0; i < this.readyMembersList.size(); ++i) {
            if (!this.readyMembersList.get(i).equals(src)) continue;
            result = false;
        }
        if (result) {
            this.readyMembersList.add(src);
        }
        return result;
    }

    void notifyReady() {
        try {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                this.logger.debug((Object)("Wait to notify ready fail " + ex));
            }
            this.channel.send(null, this.channel.getLocalAddress(), (Serializable)this.view.getViewId());
            this.logger.debug((Object)"Send successfully");
        }
        catch (Exception ex) {
            this.logger.error((Object)("Sends ready message fail " + ex));
        }
    }

    private class ViewChangedHandler
    implements Runnable {
        private ViewChangedHandler() {
        }

        public void run() {
            if (ClusterAgent.this.isFirstView) {
                ClusterAgent.this.isFirstView = false;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    ClusterAgent.this.logger.debug((Object)("Error sleeping on the first view time..." + ex));
                }
            }
            Address localAddr = ClusterAgent.this.channel.getLocalAddress();
            int clusterSize = ClusterAgent.this.view.size();
            int rank = 0;
            Vector mbrs = ClusterAgent.this.view.getMembers();
            for (int i = 0; i < mbrs.size(); ++i) {
                if (!((Address)mbrs.get(i)).equals(localAddr)) continue;
                rank = i;
                break;
            }
            if (ClusterAgent.this.controller != null) {
                ClusterAgent.this.controller.onViewChanged(clusterSize, rank);
            }
        }
    }
}

