/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import transport.message.Response;
import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.AbServiceMessage;

public class ServiceResponse
extends AbServiceMessage
implements Response {
    private String strIPSent = "";
    int mts;
    protected int contentType;
    protected int contentLength;
    protected byte[] content;
    protected int prcrtn;
    protected int status;
    protected long time;

    public ServiceResponse(String provider, String gateway, String messageId, String sessionId, String serviceId, String sender, String receiver, int contentType, int contentLength, byte[] content, int prcrtn) {
        super(5, 151 + contentLength);
        this.provider = provider;
        this.gateway = gateway;
        this.messageId = messageId;
        this.sessionId = sessionId;
        this.serviceId = serviceId;
        this.sender = sender;
        this.receiver = receiver;
        this.prcrtn = prcrtn;
        this.status = 0;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.content = new byte[contentLength];
        this.contentType = contentType;
        if (content != null) {
            int dtlen = content.length <= contentLength ? content.length : contentLength;
            System.arraycopy(content, 0, this.content, 0, dtlen);
        }
        this.time = System.currentTimeMillis();
        this.put("Name", "ServiceResponse");
        this.put("MessageId", messageId);
        this.put("SessionId", sessionId);
        this.put("ServiceId", serviceId);
        this.put("Sender", sender);
        this.put("Receiver", receiver);
        this.put("Status", this.status);
        this.put("ContentLength", contentLength);
        this.put("ContentType", contentType);
        this.put("Content", content);
        this.put("Error", this.status);
        this.put("MtTime", this.time);
        this.computeMts();
    }

    public ServiceResponse(byte[] b) throws Exception {
        super(5, 151);
        AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
        try {
            this.contentLength = buf.getInt(147);
            this.content = buf.popBytes(this.contentLength);
            this.contentLength = buf.popInt();
            this.length = 151 + this.contentLength;
            this.contentType = buf.popInt();
            this.prcrtn = buf.popInt();
            this.status = 0;
            this.receiver = buf.popCString(14);
            this.sender = buf.popCString(14);
            this.serviceId = buf.popCString(30);
            this.sessionId = buf.popCString(10);
            this.messageId = buf.popCString(10);
            this.gateway = buf.popCString(30);
            this.provider = buf.popCString(30);
            this.type = buf.popByte();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.time = System.currentTimeMillis();
        this.put("Name", "ServiceResponse");
        this.put("MessageId", this.messageId);
        this.put("SessionId", this.sessionId);
        this.put("ServiceId", this.serviceId);
        this.put("Sender", this.sender);
        this.put("Receiver", this.receiver);
        this.put("Status", this.prcrtn);
        this.put("ContentLength", this.contentLength);
        this.put("ContentType", this.contentType);
        this.put("Content", this.content);
        this.put("Error", this.prcrtn);
        this.put("MtTime", this.time);
        this.computeMts();
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        buf.appendByte(this.type);
        buf.appendCString(this.provider, 30);
        buf.appendCString(this.gateway, 30);
        buf.appendCString(this.messageId, 10);
        buf.appendCString(this.sessionId, 10);
        buf.appendCString(this.serviceId, 30);
        buf.appendCString(this.sender, 14);
        buf.appendCString(this.receiver, 14);
        buf.appendInt(this.prcrtn);
        buf.appendInt(this.contentType);
        buf.appendInt(this.contentLength);
        buf.appendBytes(this.content);
        return buf.array();
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int length) {
        this.contentLength = (short)length;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
        this.contentLength = content == null ? 0 : content.length;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getRtn() {
        return this.prcrtn;
    }

    @Override
    public void setRtn(int prcrtn) {
        this.prcrtn = prcrtn;
    }

    @Override
    public int getContentType() {
        return this.contentType;
    }

    public void setContentType(byte contentType) {
        this.contentType = contentType;
    }

    @Override
    public String debugString() {
        String debug = "";
        if ((this.status & 0x10) == 16) {
            debug = "(Retry) ";
        }
        String msgContent = this.contentType <= 8 || this.contentType != 1 ? new String(this.content) : "binary";
        return debug + "ServiceResponse " + this.sender + "->" + this.receiver + " (MsgId=" + this.messageId + ",SessionId=" + this.sessionId + ",ServiceId=" + this.serviceId + ",Return:" + this.prcrtn + ",ContentType=" + this.contentType + ",ContentLength=" + this.contentLength + ",Content=" + msgContent + ",Error=" + this.status + ",MtTime=" + this.time + ",IPSent=" + this.getIPSent() + ")";
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public int getSumMT() {
        return this.mts;
    }

    public void setSumMT(int mts) {
        this.mts = mts;
    }

    private void computeMts() {
        int e;
        int s = 0;
        if (this.contentType == 0 || this.contentType == 2) {
            String data = new String(this.content);
            for (e = 1; e <= data.length(); ++e) {
                if (e > s && (e == data.length() || e - s == 160)) {
                    ++this.mts;
                    s = e;
                    continue;
                }
                if (e >= data.length() || data.charAt(e) != 't' || e <= 0 || data.charAt(e - 1) != '\\') continue;
                ++this.mts;
                s = e + 1;
            }
        } else {
            while (e < this.content.length) {
                e = s + 140 < this.content.length ? s + 140 : this.content.length;
                ++this.mts;
                s = e;
            }
        }
    }

    public String getIPSent() {
        return this.strIPSent;
    }

    public void setIPSent(String ipSent) {
        this.strIPSent = ipSent;
    }
}

