/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionData;
import net.wimpi.telnetd.net.ConnectionEvent;
import net.wimpi.telnetd.net.ConnectionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager
implements Runnable {
    private static Log log = LogFactory.getLog(ConnectionManager.class);
    private Thread m_Thread;
    private ThreadGroup m_ThreadGroup = new ThreadGroup(new StringBuffer().append(this.toString()).append("Connections").toString());
    private List m_OpenConnections = Collections.synchronizedList(new ArrayList(100));
    private Stack m_ClosedConnections = new Stack();
    private ConnectionFilter m_Filter;
    private int m_MaxConnections;
    private int m_WarningTimeout;
    private int m_DisconnectTimeout;
    private int m_HousekeepingInterval;
    private String m_LoginShell;
    private boolean m_LineMode = false;
    private boolean m_Stopping = false;

    private ConnectionManager(int con, int timew, int timedis, int hoke, ConnectionFilter filter, String lsh, boolean lm) {
        this.m_Filter = filter;
        this.m_LoginShell = lsh;
        this.m_LineMode = lm;
        this.m_MaxConnections = con;
        this.m_WarningTimeout = timew;
        this.m_DisconnectTimeout = timedis;
        this.m_HousekeepingInterval = hoke;
    }

    public void setConnectionFilter(ConnectionFilter filter) {
        this.m_Filter = filter;
    }

    public ConnectionFilter getConnectionFilter() {
        return this.m_Filter;
    }

    public int openConnectionCount() {
        return this.m_OpenConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(int idx) {
        List list = this.m_OpenConnections;
        synchronized (list) {
            return (Connection)this.m_OpenConnections.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection[] getConnectionsByAdddress(InetAddress addr) {
        ArrayList<Connection> l = new ArrayList<Connection>();
        List list = this.m_OpenConnections;
        synchronized (list) {
            for (Connection connection : this.m_OpenConnections) {
                if (!connection.getConnectionData().getInetAddress().equals(addr)) continue;
                l.add(connection);
            }
        }
        Connection[] conns = new Connection[l.size()];
        return l.toArray(conns);
    }

    public void start() {
        this.m_Thread = new Thread(this);
        this.m_Thread.setName("telnet_connection_manager");
        this.m_Thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.debug((Object)("stop()::" + this.toString()));
        this.m_Stopping = true;
        try {
            this.m_Thread.join();
        }
        catch (InterruptedException iex) {
            log.error((Object)"stop()", (Throwable)iex);
        }
        List list = this.m_OpenConnections;
        synchronized (list) {
            Iterator iter = this.m_OpenConnections.iterator();
            while (iter.hasNext()) {
                try {
                    Connection tc = (Connection)iter.next();
                    tc.close();
                }
                catch (Exception exc) {
                    log.error((Object)"stop()", (Throwable)exc);
                }
            }
            this.m_OpenConnections.clear();
        }
        log.debug((Object)("stop():: Stopped " + this.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnection(Socket insock) {
        log.debug((Object)("makeConnection()::" + insock.toString()));
        if (this.m_Filter == null || this.m_Filter != null && this.m_Filter.isAllowed(insock.getInetAddress())) {
            ConnectionData newCD = new ConnectionData(insock, this);
            newCD.setLoginShell(this.m_LoginShell);
            newCD.setLineMode(this.m_LineMode);
            if (this.m_OpenConnections.size() < this.m_MaxConnections) {
                Connection con = new Connection(this.m_ThreadGroup, newCD);
                Object[] args = new Object[]{new Integer(this.m_OpenConnections.size() + 1)};
                log.info((Object)MessageFormat.format("connection #{0,number,integer} made.", args));
                List list = this.m_OpenConnections;
                synchronized (list) {
                    this.m_OpenConnections.add(con);
                }
                con.start();
            }
        } else {
            log.info((Object)"makeConnection():: Active Filter blocked incoming connection.");
            try {
                insock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            do {
                this.cleanupClosed();
                this.checkOpenConnections();
                Thread.sleep(this.m_HousekeepingInterval);
            } while (!this.m_Stopping);
        }
        catch (Exception e) {
            log.error((Object)"run()", (Throwable)e);
        }
        log.debug((Object)("run():: Ran out " + this.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupClosed() {
        if (this.m_Stopping) {
            return;
        }
        while (!this.m_ClosedConnections.isEmpty()) {
            Connection nextOne = (Connection)this.m_ClosedConnections.pop();
            log.info((Object)("cleanupClosed():: Removing closed connection " + nextOne.toString()));
            List list = this.m_OpenConnections;
            synchronized (list) {
                this.m_OpenConnections.remove(nextOne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenConnections() {
        if (this.m_Stopping) {
            return;
        }
        List list = this.m_OpenConnections;
        synchronized (list) {
            for (Connection conn : this.m_OpenConnections) {
                ConnectionData cd = conn.getConnectionData();
                if (!conn.isActive()) {
                    this.registerClosedConnection(conn);
                    continue;
                }
                long inactivity = System.currentTimeMillis() - cd.getLastActivity();
                if (inactivity <= (long)this.m_WarningTimeout) continue;
                if (inactivity > (long)(this.m_DisconnectTimeout + this.m_WarningTimeout)) {
                    log.debug((Object)("checkOpenConnections():" + conn.toString() + " exceeded total timeout."));
                    conn.processConnectionEvent(new ConnectionEvent(conn, 101));
                    continue;
                }
                if (cd.isWarned()) continue;
                log.debug((Object)("checkOpenConnections():" + conn.toString() + " exceeded warning timeout."));
                cd.setWarned(true);
                conn.processConnectionEvent(new ConnectionEvent(conn, 100));
            }
        }
    }

    public void registerClosedConnection(Connection con) {
        if (this.m_Stopping) {
            return;
        }
        if (!this.m_ClosedConnections.contains(con)) {
            log.debug((Object)("registerClosedConnection()::" + con.toString()));
            this.m_ClosedConnections.push(con);
        }
    }

    public static ConnectionManager createConnectionManager(String name, Properties settings) throws BootException {
        try {
            int maxc = Integer.parseInt(settings.getProperty(name + ".maxcon"));
            int timow = Integer.parseInt(settings.getProperty(name + ".time_to_warning"));
            int timodis = Integer.parseInt(settings.getProperty(name + ".time_to_timedout"));
            int hoke = Integer.parseInt(settings.getProperty(name + ".housekeepinginterval"));
            String filterclass = settings.getProperty(name + ".connectionfilter");
            ConnectionFilter filter = null;
            String loginshell = "";
            boolean linemode = false;
            if (filterclass != null && filterclass.length() != 0 && !filterclass.toLowerCase().equals("none")) {
                filter = (ConnectionFilter)Class.forName(filterclass).newInstance();
                filter.initialize(settings);
            }
            if ((loginshell = settings.getProperty(name + ".loginshell")) == null || loginshell.length() == 0) {
                log.error((Object)"Login shell not specified.");
                throw new BootException("Login shell must be specified.");
            }
            String inputmode = settings.getProperty(name + ".inputmode");
            if (inputmode == null || inputmode.length() == 0) {
                log.info((Object)"Input mode not specified using character input as default.");
                linemode = false;
            } else if (inputmode.toLowerCase().equals("line")) {
                linemode = true;
            }
            ConnectionManager cm = new ConnectionManager(maxc, timow, timodis, hoke, filter, loginshell, linemode);
            return cm;
        }
        catch (Exception ex) {
            log.error((Object)"createConnectionManager():", (Throwable)ex);
            throw new BootException("Failure while creating ConnectionManger instance:\n" + ex.getMessage());
        }
    }
}

