/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.zip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ByteArrayMaker;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipReader
implements Serializable {
    private static final int _BUFFER = 2048;
    private static Log _log = LogFactoryUtil.getLog(ZipReader.class);
    private ZipInputStream _zis;
    private Map<String, byte[]> _entries = new LinkedHashMap<String, byte[]>();
    private Map<String, List<ObjectValuePair<String, byte[]>>> _folderEntries = new LinkedHashMap<String, List<ObjectValuePair<String, byte[]>>>();
    private byte[] _data = new byte[2048];

    public ZipReader(File file) throws Exception {
        this(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipReader(InputStream stream) {
        try {
            ZipEntry entry;
            this._zis = new ZipInputStream(stream);
            while ((entry = this._zis.getNextEntry()) != null) {
                List<ObjectValuePair<String, byte[]>> files;
                int count;
                String currentName = entry.getName();
                ByteArrayMaker bam = new ByteArrayMaker();
                while ((count = this._zis.read(this._data, 0, 2048)) != -1) {
                    bam.write(this._data, 0, count);
                }
                byte[] bytes = bam.toByteArray();
                this._entries.put(currentName, bytes);
                int pos = currentName.lastIndexOf("/");
                String folderPath = "";
                String fileName = currentName;
                if (pos > 0) {
                    folderPath = currentName.substring(0, pos + 1);
                    fileName = currentName.substring(pos + 1);
                }
                if ((files = this._folderEntries.get(folderPath)) == null) {
                    files = new ArrayList<ObjectValuePair<String, byte[]>>();
                    this._folderEntries.put(folderPath, files);
                }
                ObjectValuePair<String, byte[]> ovp = new ObjectValuePair<String, byte[]>(fileName, bytes);
                files.add(ovp);
            }
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
        finally {
            block17: {
                try {
                    this._zis.close();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block17;
                    _log.warn(e);
                }
            }
        }
    }

    public Map<String, byte[]> getEntries() {
        return this._entries;
    }

    public byte[] getEntryAsByteArray(String name) {
        if (Validator.isNull(name)) {
            return null;
        }
        byte[] bytes = this._entries.get(name);
        if (bytes == null && name.startsWith("/")) {
            bytes = this._entries.get(name.substring(1));
        }
        return bytes;
    }

    public String getEntryAsString(String name) {
        byte[] bytes = this.getEntryAsByteArray(name);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public Map<String, List<ObjectValuePair<String, byte[]>>> getFolderEntries() {
        return this._folderEntries;
    }

    public List<ObjectValuePair<String, byte[]>> getFolderEntries(String path) {
        if (Validator.isNull(path)) {
            return null;
        }
        return this._folderEntries.get(path);
    }
}

