/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class UnicodeFormatter {
    public static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Log _log = LogFactoryUtil.getLog(UnicodeFormatter.class);

    public static String byteToHex(byte b) {
        char[] array = new char[]{HEX_DIGIT[b >> 4 & 0xF], HEX_DIGIT[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return UnicodeFormatter.byteToHex(hi) + UnicodeFormatter.byteToHex(lo);
    }

    public static String parseString(String hexString) {
        StringBuilder sb = new StringBuilder();
        char[] array = hexString.toCharArray();
        if (array.length % 6 != 0) {
            _log.error("String is not in hex format");
            return hexString;
        }
        for (int i = 2; i < hexString.length(); i += 6) {
            String s = hexString.substring(i, i + 4);
            try {
                char c = (char)Integer.parseInt(s, 16);
                sb.append(c);
                continue;
            }
            catch (Exception e) {
                _log.error(e, e);
                return hexString;
            }
        }
        return sb.toString();
    }

    public static String toString(char[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append("\\u");
            sb.append(UnicodeFormatter.charToHex(array[i]));
        }
        return sb.toString();
    }

    public static String toString(String s) {
        if (s == null) {
            return null;
        }
        return UnicodeFormatter.toString(s.toCharArray());
    }
}

