/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import java.io.File;
import java.util.Set;
import javax.servlet.ServletContext;

public class ServletContextUtil {
    public static long getLastModified(ServletContext servletContext) {
        return ServletContextUtil.getLastModified(servletContext, "/");
    }

    public static long getLastModified(ServletContext servletContext, String resourcePath) {
        return ServletContextUtil.getLastModified(servletContext, resourcePath, false);
    }

    public static long getLastModified(ServletContext servletContext, String resourcePath, boolean cache) {
        Long lastModified;
        int pos;
        if (resourcePath.startsWith("http") || resourcePath.startsWith("https")) {
            pos = resourcePath.indexOf("://");
            resourcePath = resourcePath.substring(pos + 3);
        }
        if ((pos = resourcePath.indexOf("/")) != -1) {
            resourcePath = resourcePath.substring(pos);
        }
        if (cache && (lastModified = (Long)servletContext.getAttribute(ServletContextUtil.class.getName() + "." + resourcePath)) != null) {
            return lastModified;
        }
        long lastModified2 = 0L;
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths != null) {
            for (String curResourcePath : resourcePaths) {
                File file;
                if (curResourcePath.endsWith("/")) {
                    long curLastModified = ServletContextUtil.getLastModified(servletContext, curResourcePath);
                    if (curLastModified <= lastModified2) continue;
                    lastModified2 = curLastModified;
                    continue;
                }
                String realPath = servletContext.getRealPath(curResourcePath);
                if (realPath == null || (file = new File(realPath)).lastModified() <= lastModified2) continue;
                lastModified2 = file.lastModified();
            }
        }
        if (cache) {
            servletContext.setAttribute(ServletContextUtil.class.getName() + "." + resourcePath, (Object)new Long(lastModified2));
        }
        return lastModified2;
    }
}

