/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PortalInitable;
import com.liferay.portal.kernel.util.PortalInitableUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;

public class PortletContextListener
implements PortalInitable,
ServletContextListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static Log _log = LogFactoryUtil.getLog(PortletContextListener.class);
    private ServletContext _servletContext;
    private ClassLoader _classLoader;
    private boolean _bindLiferayPool;

    public void contextDestroyed(ServletContextEvent event) {
        block8: {
            ServletContext servletContext = event.getServletContext();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            HotDeployUtil.fireUndeployEvent(new HotDeployEvent(servletContext, contextClassLoader));
            try {
                if (!this._bindLiferayPool) {
                    return;
                }
                this._bindLiferayPool = false;
                if (_log.isDebugEnabled()) {
                    _log.debug("Dynamically unbinding the Liferay data source");
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException ne) {
                    context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                }
                try {
                    context.lookup(_JNDI_JDBC);
                }
                catch (NamingException ne) {
                    context.destroySubcontext(_JNDI_JDBC);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn("Unable to dynamically unbind the Liferay data source: " + e.getMessage());
            }
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        this._servletContext = event.getServletContext();
        Thread currentThread = Thread.currentThread();
        this._classLoader = currentThread.getContextClassLoader();
        PortalInitableUtil.init(this);
    }

    public void portalInit() {
        block12: {
            HotDeployUtil.fireDeployEvent(new HotDeployEvent(this._servletContext, this._classLoader));
            try {
                DataSource dataSource;
                if (ServerDetector.isGlassfish2()) {
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("Dynamically binding the Liferay data source");
                }
                if ((dataSource = InfrastructureUtil.getDataSource()) == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("Abort dynamically binding the Liferay data source because it is not available");
                    }
                    return;
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC);
                }
                catch (NamingException ne) {
                    context.createSubcontext(_JNDI_JDBC);
                }
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException ne) {
                    try {
                        Method method = dataSource.getClass().getMethod("getTargetDataSource", new Class[0]);
                        dataSource = (DataSource)method.invoke((Object)dataSource, new Object[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                    context.bind(_JNDI_JDBC_LIFERAY_POOL, (Object)dataSource);
                }
                this._bindLiferayPool = true;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn("Unable to dynamically bind the Liferay data source: " + e.getMessage());
            }
        }
    }
}

